% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ListReports.R
\name{ListReports}
\alias{ListReports}
\title{List Available Reports}
\usage{
ListReports(path = NULL, SelectREPORT = NULL)
}
\arguments{
\item{path}{string, path to the /Reports/ folder.}

\item{SelectREPORT}{integer, Report ID value determined from
MobileTrigger::ListReports() output when SelectREPORT = NULL}
}
\value{
If SelectREPORT = NULL: An HTML table of all scripts in the /Reports/
folder. If SelectREPORT is a Report ID number from the complete report list it
only returns and HTML table with the selected report.
}
\description{
Creates an HTML table for all or selected reports in the
[TRIGGER_PATH]/Reports/ folder. This table is used as part of a message
being sent out to a receiving e-mail client.
}
\examples{
\donttest{
################################
# Get all the Available Reports #
################################
  REPORTPATH <- "C:/Triggers/Reports/"
  HTML.Message <- ListReports(path = REPORTPATH)
  ## Use the HTML.Message to send table of Reports with MailR package.

#############################
# Get Selected  Reports     #
#############################
  HTML.Message <- ListReports(path = REPORTPATH, SelectREPORT = 1)
  ## Use the HTML.Message to send table of Selected Script with MailR package.
}
}
