% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.Cox.R
\name{summary.Cox}
\alias{summary.Cox}
\title{Summary of parameter estimates of a Cox model}
\usage{
\method{summary}{Cox}(object, digits = 4, ...)
}
\arguments{
\item{object}{Output from a call to Cox.}

\item{digits}{The desired number of digits after the decimal point. Default of 4 digits is used.}

\item{...}{Additional arguments}
}
\value{
Summary for \code{CoxMM} objects.
}
\description{
This function returns the result of the \code{CoxMM} function
}
\examples{

library(survival)
result <- CoxMM(Surv(time, status) ~ age + sex, lung)

summary(result,digits=4)



}
\seealso{
\code{\link{CoxMM}}
}
\keyword{methods}
