% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHpltStats_func_20200915.R
\name{GetHpltStats}
\alias{GetHpltStats}
\title{GetHpltStats() function}
\usage{
GetHpltStats(filepath)
}
\arguments{
\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}
}
\value{
A mean of the mean proportion of incongruent sequences for each
  nest.
}
\description{
\code{\link{GetHpltStats}} uses the output files produced by the HpltFind()
function to calculate the mean of the mean proportion of incongruent
sequences across all nests in the data set.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. (2022). MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J. (2024). MHCtools 1.5: Analysis of MHC sequencing data in R. In S.
Boegel (Ed.), HLA Typing: Methods and Protocols (2nd ed., pp. 275–295).
Humana Press. https://doi.org/https://doi.org/10.1007/978-1-0716-3874-3_18
}
\examples{
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
GetHpltStats(filepath)
}
\seealso{
\code{\link{HpltFind}}; \code{\link{GetHpltTable}}
}
