% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateHpltOccTable_func_20221010.R
\name{CreateHpltOccTable}
\alias{CreateHpltOccTable}
\title{CreateHpltOccTable() function}
\usage{
CreateHpltOccTable(seq_table, filepath, path_out)
}
\arguments{
\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A binary (logical) occurrence matrix with the data set sequences
  (inherited from seq_table) in columns and the putative haplotypes inferred
  by the HpltFind() function in rows.
}
\description{
\code{\link{CreateHpltOccTable}} is designed to create a haplotype-sequence
occurrence matrix from the set of R lists with putative haplotypes output
by the HpltFind() function. CreateHpltOccTable() assumes that data originated
from a diploid species.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools - an R package for MHC high-throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non-model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
seq_table <- sequence_table
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
path_out <- tempdir()
CreateHpltOccTable(seq_table, filepath, path_out)
}
\seealso{
\code{\link{HpltFind}}; for more information about 'dada2' visit
<https://benjjneb.github.io/dada2/>
}
