% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHpltTable_func_20170924.R
\name{GetHpltTable}
\alias{GetHpltTable}
\title{GetHpltTable() function}
\usage{
GetHpltTable(filepath)
}
\arguments{
\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}
}
\value{
A table with the mean proportion of incongruent sequences for each
  nest.
}
\description{
\code{\link{GetHpltTable}} uses the output files produced by the HpltFind()
function to produce a table with the mean proportion of incongruent sequences
for each nest. If the mean proportion of incongruent sequences is generally
low, but certain nests have many incongruent sequences, biological reasons
may be causing the mismatches, e.g. extra-pair fertilizations or
recombination events.
}
\examples{
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
GetHpltTable(filepath)
}
\seealso{
\code{\link{HpltFind}}; \code{\link{GetHpltStats}}
}
