% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanPdist_func_20171023.R
\name{MeanPdist}
\alias{MeanPdist}
\title{MeanPdist() function}
\usage{
MeanPdist(seq_table, codon_pos = NULL)
}
\arguments{
\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{codon_pos}{optional, a vector of codon positions to include in
p-distance calculations, if this argument is omitted, p-distance
calculations are made using all codons.}
}
\value{
A table with the mean p-distance for each sample.
}
\description{
\code{\link{MeanPdist}} calculates the mean p-distance from pairwise
comparisons of the sequences in each sample in a 'dada2' sequence table.
Note: Sequences are required to be of equal length.
}
\examples{
seq_table <- sequence_table_fas
codon_pos <- c(1,2,3,4,5,6,7,8)
MeanPdist(seq_table, codon_pos)
}
\seealso{
For more information about 'dada2'visit
  <https://benjjneb.github.io/dada2>
}
