% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MetaRanking.R
\name{MetaRanking}
\alias{MetaRanking}
\title{Implementation of MetaRanking function for Multi-Criteria Decision Making Problems.}
\usage{
MetaRanking(decision, weights, cb, lambda, v)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}

\item{lambda}{A value in [0,1]. It is used in the calculation of the W index for WASPAS method.}

\item{v}{A value in [0,1]. It is used in the calculation of the Q index for VIKOR method.}
}
\value{
\code{MetaRanking} returns a data frame which contains the rankings of the Multi-MOORA, TOPSIS, VIKOR, WASPAS Methods and the MetaRanking of the alternatives.
}
\description{
The \code{MetaRanking} function internally calls functions  \code{MMOORA}, \code{TOPSIS}, \code{VIKOR} and \code{WASPAS} and then calculates a sum of the their rankings.
}
\examples{
d <- matrix(rpois(12, 5), nrow = 4)
 w <- c(0.2, 0.2, 0.6)
 cb <- c('max','min','max')
 lambda <- 0.5
 v <- 0.5
 MetaRanking(d,w,cb,lambda,v)
}

