% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_05_DE_6_2_GO_Plot.R
\name{BioPathways.Plot.10x}
\alias{BioPathways.Plot.10x}
\title{Plot pathway enrichment analysis results}
\usage{
BioPathways.Plot.10x(MarvelObject, go.terms, y.label.size = 10, offset = 0.5)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{BioPathways.10x} function.}

\item{go.terms}{Vector of character strings. Names of pathways to plot. Should match pathway names in column \code{Description} of \code{MarvelObject$DE$BioPathways$Table}.}

\item{y.label.size}{Numeric value. Size of y-axis tick labels, i.e. pathway names.}

\item{offset}{Numeric value. The value on the x-axis to substract or add to increase the plot margins.}
}
\value{
An object of class S3 containing with new slot \code{MarvelObject$DE$BioPathways$Plot}.
}
\description{
Plots user-specified enriched pathways.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define top pathways to plot
go.terms <- marvel.demo.10x$DE$BioPathways$Table$Description
go.terms <- go.terms[c(1:10)]

# Plot
marvel.demo.10x <- BioPathways.Plot.10x(
                            MarvelObject=marvel.demo.10x,
                            go.terms=go.terms
                            )
# Check outpout
marvel.demo.10x$DE$BioPathways$Plot
}
