% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_tests.R
\name{beta_shape1_one_way}
\alias{beta_shape1_one_way}
\title{Test the equality of shape 1 parameters of beta distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
beta_shape1_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of shape 1 parameters of beta distributions.
}
\details{
\itemize{
\item Null: All shape1s are equal. (shape1_1 = shape1_2 ... shape1_k).
\item Alternative: At least one shape1 is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rbeta(150, 1, 2)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
beta_shape1_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rbeta(50, 1, 2), rbeta(50, 2, 2), rbeta(50, 3, 2))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
beta_shape1_one_way(x, fctr, .95)
}
