\name{LDheatmap.highlight}
\alias{LDheatmap.highlight}
\title{ Highlight a genetic region in the linkage disequilibrium heat map }
\description{ 
   The function \code{LDheatmap.highlight} is used to highlight a
   specified genetic region in the linkage disequilibrium (LD) 
   heat map drawn with the \code{\link{LDheatmap}} function.
}
\usage{
LDheatmap.highlight(LDheatmap, i, j, fill = "NA", col = "black", lwd = 1, lty = 1)
}
\arguments{
  \item{LDheatmap}{ An object of class \code{"LDheatmap"} (returned 
by the function \code{LDheatmap}).}
  \item{i}{ A numeric value specifying the index of the first 
            SNP to be in the highlighted region. }
  \item{j}{ A numeric value specifying the index of the last SNP, 
    which must be different from \code{i}, to be in the highlighted region. }
  \item{fill}{ Color to fill the highlighted area with. }
  \item{col}{ A character string specifying the color of the line 
    segments defining the boundary of highlighted region; see 
    \code{\link[graphics]{par}}. }
  \item{lwd}{ A \emph{positive} number specifying the width of the 
     boundary segments. }
  \item{lty}{ Either an integer or a character string specifying the 
     line type of the boundary segments; see \code{\link[graphics]{par}}
     for possible values. }
}
\value{ A data frame of the x and y coordinates of points defining the 
border of the highlighted area. }
\note{ The function \code{LDheatmap.highlight} highlights the cells representing 
	the pairwise LD for the SNPs located between \code{i}-th and \code{j}-th (inclusive) 
	SNPs in the genomic region of interest.  
	Note that the order of indices has no effect on the plot.  For example, 
	\code{LDheatmap.highlight(LDheatmap, i=2, j=4)} is the same as 
	\code{LDheatmap.highlight(LDheatmap, i=4, j=2)}, which highlights 
	the cells representing the pairwise LD for the second, 
	third and fourth SNPs. }
\author{ Nicholas Lewin-Koh <nikko@hailmail.net>, Ji-hyung Shin 
<jshinb@sfu.ca>, Sigal Blay <sblay@sfu.ca> }
\examples{
data(LDheatmapData)
tt <- LDheatmap(HapMap.dat, genetic.distances=distance)
LDheatmap.highlight(tt, 3, 8, col="blue", fill="green", lwd=3)
}
\keyword{ aplot }

