% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.JointAI}
\alias{predict.JointAI}
\title{Predict values from an object of class JointAI}
\usage{
\method{predict}{JointAI}(object, outcome = 1L, newdata,
  quantiles = c(0.025, 0.975), type = "lp", start = NULL, end = NULL,
  thin = NULL, exclude_chains = NULL, mess = TRUE, warn = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{outcome}{vector of variable names or integers identifying for which
outcome(s) the prediction should be performed.}

\item{newdata}{optional new dataset for prediction. If left empty, the
original data is used.}

\item{quantiles}{quantiles of the predicted distribution of the outcome}

\item{type}{the type of prediction. The default is on the scale of the linear
predictor (\code{"link"} or \code{"lp"}). Additionally, for generalized
linear (mixed) models (incl. beta and log-normal) \code{type = "response"}
transforms the predicted values to the scale of the response, and for
ordinal and multinomial (mixed) models \code{type} may be \code{"prob"} (to
obtain probabilities per class), \code{"class"} to obtain the class with
the highest posterior probability, or \code{"lp"}. For parametric survival
models \code{type} can be \code{"lp" } or "response", and for proportional
hazards survival models the options are \code{"lp"}, \code{"risk"} (=
\code{exp(lp)}), \code{"survival"} or \code{"expected"} (=
\code{-log(survival)}).}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{...}{currently not used}
}
\value{
A list with entries \code{dat}, \code{fit} and \code{quantiles},
where \code{fit} contains the predicted values (mean over the values
calculated from the iterations of the MCMC sample), \code{quantiles}
contain the specified quantiles (by default 2.5\% and 97.5\%), and \code{dat}
is \code{newdata}, extended with \code{fit} and \code{quantiles} (unless
prediction for an ordinal outcome is done with \code{type = "prob"}, in
which case the quantiles are an array with three dimensions and are
therefore not included in \code{dat}).
}
\description{
Obtains predictions and corresponding credible intervals from an object of
class 'JointAI'.
}
\details{
A \code{model.matrix} \eqn{X} is created from the model formula
(currently fixed effects only) and \code{newdata}. \eqn{X\beta} is then
calculated for each iteration of the MCMC sample in \code{object}, i.e.,
\eqn{X\beta} has \code{n.iter} rows and \code{nrow(newdata)} columns. A
subset of the MCMC sample can be selected using \code{start}, \code{end}
and  \code{thin}.
}
\section{Note}{
 \itemize{ \item So far, \code{predict} cannot calculate
predicted values for cases with missing values in covariates. Predicted
values for such cases are \code{NA}. \item For repeated measures models
prediction currently only uses fixed effects. } Functionality will be
extended in the future.
}

\examples{
# fit model
mod <- lm_imp(y ~ C1 + C2 + I(C2^2), data = wideDF, n.iter = 100)

# calculate the fitted values
fit <- predict(mod)

# create dataset for prediction
newDF <- predDF(mod, vars = ~ C2)

# obtain predicted values
pred <- predict(mod, newdata = newDF)

# plot predicted values and 95\% confidence band
matplot(newDF$C2, pred$fitted, lty = c(1, 2, 2), type = "l", col = 1,
xlab = 'C2', ylab = 'predicted values')

}
\seealso{
\code{\link{predDF.JointAI}}, \code{\link[JointAI:model_imp]{*_imp}}
}
