% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate dataset}
\usage{
sim_data(
  N = 100,
  Jmin = 1,
  Jmax = 6,
  tmin = 0,
  tmax = 5,
  norm = 2,
  bin = 2,
  multi = 2,
  ord = 2,
  count = 2,
  longnorm = 2,
  longbin = 2,
  longord = 2,
  longcount = 2,
  coef = NULL,
  misvar = NULL,
  nmisvar = 7,
  seed = NULL
)
}
\arguments{
\item{N}{sample size (integer)}

\item{Jmin}{minimum number of repeated measurements in longitudinal variable}

\item{Jmax}{maximum number of repeated measurements in longitudinal variable}

\item{tmin}{minimum of time variable}

\item{tmax}{maximum of time variable}

\item{norm}{integer giving the number of normally distributed variables to
create or list of parameters to create normally distributed variables
from. If norm is an integer, the mean and standard deviation are
drawn from distributions.}

\item{bin}{integer giving the number of binary variables or a character vector containing their names}

\item{multi}{integer giving the number of multinomial variables or a character vector containing their names}

\item{ord}{integer giving the number of ordinal variables or a character vector containing their names}

\item{count}{integer giving the number of count variables or a character vector containing their names}

\item{longnorm}{integer giving the number of longitudinal (normally distributed)
variables or a character vector containing their names}

\item{longbin}{integer giving the number of longitudinal binary
variables or a character vector containing their names}

\item{longord}{integer giving the number of longitudinal ordered factors
or a character vector containing their names}

\item{longcount}{integer giving the number of longitudinal count variables
or a character vector containing their names}

\item{coef}{vector of parameters used to create the outcome (optional), if
NULL, the parameters are drawn from a normal distribution}

\item{misvar}{vector of variable names or positions to
specify which variables are incomplete}

\item{nmisvar}{integer specifying the total number of incomplete variables,
necessary when misvar is NULL and incomplete variables are chosen
randomly}

\item{seed}{optional seed value}
}
\description{
Simulate dataset
}
\details{
The time variable has a uniform distribution between tmin and tmax.
         At the moment only the integer option is implemented for the
         parameters norm, bin, multi, etc.
}
\keyword{internal}
