% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.JointAI}
\alias{predict.JointAI}
\title{Predict values from an object of class JointAI}
\usage{
\method{predict}{JointAI}(object, newdata, quantiles = c(0.025, 0.975),
  start = NULL, end = NULL, thin = NULL, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{newdata}{new dataset for prediction}

\item{quantiles}{quantiles of the predicted distribution of the outcome}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{...}{currently not used}
}
\value{
A list with entries "fit" and "quantiles", where
        "fit" contains the column means of \eqn{X\beta} (see details)
        and "quantiles" contain the specified quantiles (by default 2.5\%
        and 97.5\%) of each column of \eqn{X\beta}.
}
\description{
Calculates the expected outcome value for a given set of covariate values
and an object of class 'JointAI', and corresponding 2.5\% and 97.5\% (or other
quantiles) credible intervals.
}
\details{
A \code{model.matrix} \eqn{X} is created from the model formula (fixed
         effects only) and \code{newdata}. \eqn{X\beta} is then calculated for
         each iteration of the MCMC sample in \code{object}, i.e., \eqn{X\beta}
         has \code{n.iter} rows and \code{nrow(newdata)} columns.
         A subset of the MCMC sample can be selected using \code{start},
         \code{end} and  \code{thin}.
}
\section{Note}{

\itemize{
\item For repeated measures models prediction is performed on fixed effects only.
\item Prediction is performed on the scale of the linear predictor.
}
Functionality will be extended in the future.
}

\examples{
# fit model
mod <- lm_imp(y ~ C1 + C2 + I(C2^2), data = wideDF, n.iter = 100)

# create dataset for prediction
newDF <- predDF(mod, var = "C2")

# obtain predicted values
pred <- predict(mod, newdata = newDF)

# plot predicted values and 95\% confidence band
plot(newDF$C2, pred$fit, type = "l", ylim = range(pred$quantiles),
     xlab = "C2", ylab = "predicted values")
matplot(newDF$C2, t(pred$quantiles), lty = 2, add = TRUE, type = "l", col = 1)

}
\seealso{
\code{\link{predDF.JointAI}}, \code{\link{lme_imp}}, \code{\link{glm_imp}},
          \code{\link{lm_imp}}
}
