% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-datasets.R
\docType{data}
\name{CalibDataBat}
\alias{CalibDataBat}
\alias{CalibDataBatRev}
\title{Calibration datasets for bat species}
\format{
Two \emph{dataframes} with 335 observations and 7 variables:\tabular{lll}{
    \tab  \tab  \cr
   site_ID \tab (\emph{factor}) \tab Identification of the sampling site \cr
   long \tab (\emph{numeric}) \tab Longitude coordinate (decimal degrees) \cr
   lat \tab (\emph{numeric}) \tab Latitude coordinate (decimal degrees) \cr
   elev \tab (\emph{numeric}) \tab Elevation asl (m) \cr
   sample_ID \tab (\emph{factor}) \tab Identification of the sampled animal \cr
   species \tab (\emph{factor}) \tab A code for the species \cr
   sample_value \tab (\emph{numeric}) \tab Hydrogen delta value of the tissue \cr
}
}
\source{
data provided by Voigt CC & Lehnert L.
}
\description{
These datasets contain hydrogen delta values of fur keratin from 6 sedentary
bat species. They correspond to the combination of several studies as detailed
in Voigt & Lenhert 2019. \code{CalibDataBat} is the dataset used in Courtiol et al. 2019.
The data can be used as an example to fit a calibration model using the
function \code{\link{calibfit}}. \code{CalibDataBatRev} is the same data but the bat
fur isotope values were corrected to align with the current delta values for deuterium
for keratin reference materials (Soto et al. 2017, https://doi.org/10.1002/rcm.7893)
ensuring comparability between formerly and more recently normalized datasets of delta values for deuterium.
}
\details{
Users who wish to use their own dataset for calibration should create a
\emph{dataframe} of similar structure than these ones (only the column 'species'
can be dropped). The columns should possess the same names as the ones
described above. If the elevation is unknown at the sampling sites, elevation
information can be extracted from a high resolution elevation raster using
the function \code{\link[terra:extract]{terra::extract}} (see \strong{Examples} in
\code{\link{CalibDataBat2}}).
}
\examples{

head(CalibDataBat)
str(CalibDataBat)
}
\references{
Voigt CC & Lehnert L (2019). Tracking of movements of terrestrial
mammals using stable isotopes. In Hobson KA & Wassenaar LI (eds.), Tracking Animal
Migration with Stable Isotopes, second edition. Academic Press, London.

Courtiol A, Rousset F, Rohwäder M, Soto DX, Lehnert L, Voigt CC, Hobson KA, Wassenaar LI & Kramer-Schadt S (2019). Isoscape
computation and inference of spatial origins with mixed models using the R package IsoriX. In Hobson KA & Wassenaar LI (eds.),
Tracking Animal Migration with Stable Isotopes, second edition. Academic Press, London.

Soto DX, Koehler G, Wassenaar LI & Hobson KA (2017). Re-evaluation of the hydrogen stable
isotopic composition of keratin calibration standards for wildlife and forensic
science applications. Rapid Commun Mass Spectrom. 31(14):1193-1203.
doi: 10.1002/rcm.7893. PMID: 28475227.
}
\seealso{
\code{\link{CalibDataBat2}} for another (related) calibration dataset

\code{\link{calibfit}} to fit a calibration model
}
\keyword{datasets}
