% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{kde}
\alias{kde}
\alias{kde.default}
\alias{kde.UPb}
\alias{kde.detritals}
\alias{kde.PbPb}
\alias{kde.ArAr}
\alias{kde.KCa}
\alias{kde.ThPb}
\alias{kde.ThU}
\alias{kde.ReOs}
\alias{kde.SmNd}
\alias{kde.RbSr}
\alias{kde.LuHf}
\alias{kde.UThHe}
\alias{kde.fissiontracks}
\title{Create (a) kernel density estimate(s)}
\usage{
kde(x, ...)

\method{kde}{default}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  hide = NULL,
  ...
)

\method{kde}{UPb}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  type = 4,
  cutoff.76 = 1100,
  cutoff.disc = discfilter(),
  common.Pb = 0,
  hide = NULL,
  ...
)

\method{kde}{detritals}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = NA,
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  ncol = NA,
  samebandwidth = TRUE,
  normalise = TRUE,
  hide = NULL,
  ...
)

\method{kde}{PbPb}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  common.Pb = 2,
  hide = NULL,
  ...
)

\method{kde}{ArAr}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = FALSE,
  hide = NULL,
  ...
)

\method{kde}{KCa}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = FALSE,
  hide = NULL,
  ...
)

\method{kde}{ThPb}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = FALSE,
  hide = NULL,
  ...
)

\method{kde}{ThU}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [ka]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = FALSE,
  detritus = 0,
  hide = NULL,
  ...
)

\method{kde}{ReOs}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{kde}{SmNd}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{kde}{RbSr}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{kde}{LuHf}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  i2i = TRUE,
  hide = NULL,
  ...
)

\method{kde}{UThHe}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  hide = NULL,
  ...
)

\method{kde}{fissiontracks}(
  x,
  from = NA,
  to = NA,
  bw = NA,
  adaptive = TRUE,
  log = FALSE,
  n = 512,
  plot = TRUE,
  pch = "|",
  xlab = "age [Ma]",
  ylab = "",
  kde.col = rgb(1, 0, 1, 0.6),
  hist.col = rgb(0, 1, 0, 0.2),
  show.hist = TRUE,
  bty = "n",
  binwidth = NA,
  hide = NULL,
  ...
)
}
\arguments{
\item{x}{a vector of numbers OR an object of class \code{UPb},
\code{PbPb}, \code{ThPb}, \code{ArAr}, \code{KCa}, \code{ReOs},
\code{SmNd}, \code{RbSr}, \code{UThHe}, \code{fissiontracks},
\code{ThU} or \code{detrital}}

\item{...}{optional arguments to be passed on to \code{R}'s
\code{density} function.}

\item{from}{minimum age of the time axis. If \code{NULL}, this is
set automatically}

\item{to}{maximum age of the time axis. If \code{NULL}, this is set
automatically}

\item{bw}{the bandwidth of the KDE. If \code{NULL}, \code{bw} will
be calculated automatically using the algorithm by Botev et
al. (2010).}

\item{adaptive}{logical flag controlling if the adaptive KDE
modifier of Abramson (1982) is used}

\item{log}{transform the ages to a log scale if \code{TRUE}}

\item{n}{horizontal resolution (i.e., the number of segments) of
the density estimate.}

\item{plot}{show the KDE as a plot}

\item{pch}{the symbol used to show the samples. May be a vector.
Set \code{pch=NA} to turn them off.}

\item{xlab}{the x-axis label}

\item{ylab}{the y-axis label}

\item{kde.col}{the fill colour of the KDE specified as a four
element vector of \code{r, g, b, alpha} values}

\item{hist.col}{the fill colour of the histogram specified as a
four element vector of \code{r, g, b, alpha} values}

\item{show.hist}{logical flag indicating whether a histogram should
be added to the KDE}

\item{bty}{change to \code{"o"}, \code{"l"}, \code{"7"},
\code{"c"}, \code{"u"}, or \code{"]"} if you want to draw a box
around the plot}

\item{binwidth}{scalar width of the histogram bins, in Myr if
\code{log = FALSE}, or as a fractional value if \code{log =
TRUE}. Sturges' Rule (\eqn{\log_2[n]+1}, where \eqn{n} is the
number of data points) is used if \code{binwidth = NA}}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), the concordia age (\code{type}=5), or the
\eqn{^{208}}Pb/\eqn{^{232}}Th age (\code{type}=6).}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{discordance cutoff filter. This is an object of
class \code{\link{discfilter}}.}

\item{common.Pb}{common lead correction:

\code{0}: none

\code{1}: use the Pb-composition stored in

\code{settings('iratio','Pb206Pb204')} (if \code{x} has class
\code{UPb} and \code{x$format<4});

\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{x} has class
\code{PbPb} or \code{x} has class \code{UPb} and
\code{3<x$format<7}); or

\code{settings('iratio','Pb208Pb206')} and
\code{settings('iratio','Pb208Pb207')} (if \code{x} has class
\code{UPb} and \code{x$format=7,8}).

\code{2}: use the isochron intercept as the initial Pb-composition

\code{3}: use the Stacey-Kramers two-stage model to infer the
initial Pb-composition (only valid if \code{x} has class
\code{UPb}).}

\item{ncol}{scalar value indicating the number of columns over
which the KDEs should be divided.}

\item{samebandwidth}{logical flag indicating whether the same
bandwidth should be used for all samples. If
\code{samebandwidth = TRUE} and \code{bw = NULL}, then the
function will use the median bandwidth of all the samples.}

\item{normalise}{logical flag indicating whether or not the KDEs
should all integrate to the same value.}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{40}}Ca/\eqn{^{44}}Ca,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{230}}Th/\eqn{^{232}}Th, \eqn{^{176}}Hf/\eqn{^{177}}Hf or
\eqn{^{204}}Pb/\eqn{^{208}}Pb ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}.}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format=1} or \code{2}).

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}
}
\value{
If \code{x} has class \code{UPb}, \code{PbPb}, \code{ArAr},
    \code{KCa}, \code{ReOs}, \code{SmNd}, \code{RbSr},
    \code{UThHe}, \code{fissiontracks} or \code{ThU}, returns an
    object of class \code{KDE}, i.e. a list containing the
    following items:

\describe{
\item{x}{ horizontal plot coordinates}
\item{y}{ vertical plot coordinates}
\item{bw}{ the base bandwidth of the density estimate}
\item{ages}{ the data values from the input to
the \code{kde} function}
\item{log}{ copied from the input}
}

or, if \code{x} has class \code{=detritals}, an object of class
\code{KDEs}, i.e. a list containing the following items:

\describe{
\item{kdes}{a named list with objects of class \code{KDE}}
\item{from}{the beginning of the common time scale}
\item{to}{the end of the common time scale}
\item{themax}{the maximum probability density of all the KDEs}
\item{xlabel}{the x-axis label to be used by \code{plot.KDEs(...)}}
}
}
\description{
Creates one or more kernel density estimates using a combination of
the Botev (2010) bandwidth selector and the Abramson (1982)
adaptive kernel bandwidth modifier.
}
\details{
Given a set of \eqn{n} age estimates \eqn{\{t_1, t_2, ..., t_n\}},
histograms and KDEs are probability density estimators that display
age distributions by smoothing.  Histograms do this by grouping the
data into a number of regularly spaced bins.  Alternatively, kernel
density estimates (KDEs; Vermeesch, 2012) smooth data by applying a
(Gaussian) kernel:

\eqn{KDE(t) = \sum_{i=1}^{n}N(t|\mu=t_i,\sigma=h[t])/n}

where \eqn{N(t|\mu,\sigma)} is the probability of observing a value
\eqn{t} under a Normal distribution with mean \eqn{\mu} and
standard deviation \eqn{\sigma}.  \eqn{h[t]} is the smoothing
parameter or `bandwidth' of the kernel density estimate, which may
or may not depend on the age \eqn{t}. If \eqn{h[t]} depends on
\eqn{t}, then \eqn{KDE(t)} is known as an `adaptive' KDE.  The
default bandwidth used by \code{IsoplotR} is calculated using the
algorithm of Botev et al. (2010) and modulated by the adaptive
smoothing approach of Abramson (1982).  The rationale behind
adaptive kernel density estimation is to use a narrower bandwidth
near the peaks of the sampling distribution (where the ordered
dates are closely spaced in time), and a wider bandwidth in the
distribution's sparsely sampled troughs. Thus, the resolution of
the density estimate is optimised according to data availability.
}
\examples{
kde(examples$UPb)

dev.new()
kde(examples$FT1,log=TRUE)

dev.new()
kde(examples$DZ,from=1,to=3000,kernel="epanechnikov")
}
\references{
Abramson, I.S., 1982. On bandwidth variation in kernel estimates-a
square root law. The annals of Statistics, pp.1217-1223.

Botev, Z. I., J. F. Grotowski, and
D. P. Kroese. "Kernel density estimation via diffusion." The Annals
of Statistics 38.5 (2010): 2916-2957.

Vermeesch, P., 2012. On the visualisation of detrital age
distributions. Chemical Geology, 312, pp.190-194.
}
\seealso{
\code{\link{radialplot}}, \code{\link{cad}}
}
