% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radialplot.R
\name{radialplot}
\alias{radialplot}
\alias{radialplot.default}
\alias{radialplot.fissiontracks}
\alias{radialplot.UPb}
\alias{radialplot.PbPb}
\alias{radialplot.ArAr}
\alias{radialplot.KCa}
\alias{radialplot.UThHe}
\alias{radialplot.ReOs}
\alias{radialplot.SmNd}
\alias{radialplot.RbSr}
\alias{radialplot.LuHf}
\alias{radialplot.ThU}
\title{Visualise heteroscedastic data on a radial plot}
\usage{
radialplot(x, ...)

\method{radialplot}{default}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", sigdig = 2, show.numbers = FALSE,
  pch = 21, levels = NA, clabel = "", bg = c("yellow", "red"),
  col = "black", title = TRUE, k = 0, markers = NULL,
  alpha = 0.05, units = "", hide = NA, omit = NA, omit.col = NA,
  ...)

\method{radialplot}{fissiontracks}(x, from = NA, to = NA, t0 = NA,
  transformation = "arcsin", sigdig = 2, show.numbers = FALSE,
  pch = 21, levels = NA, clabel = "", bg = c("yellow", "red"),
  col = "black", title = TRUE, markers = NULL, k = 0,
  exterr = TRUE, alpha = 0.05, hide = NULL, omit = NULL,
  omit.col = NA, ...)

\method{radialplot}{UPb}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", type = 4, cutoff.76 = 1100,
  cutoff.disc = list(-15, 5, TRUE), show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, common.Pb = 0,
  alpha = 0.05, hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{PbPb}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, common.Pb = 1,
  alpha = 0.05, hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{ArAr}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = FALSE,
  alpha = 0.05, hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{KCa}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = FALSE,
  alpha = 0.05, hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{UThHe}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, alpha = 0.05, hide = NULL, omit = NULL,
  omit.col = NA, ...)

\method{radialplot}{ReOs}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = TRUE, alpha = 0.05,
  hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{SmNd}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = TRUE, alpha = 0.05,
  hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{RbSr}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = TRUE, alpha = 0.05,
  hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{LuHf}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, exterr = TRUE, i2i = TRUE, alpha = 0.05,
  hide = NULL, omit = NULL, omit.col = NA, ...)

\method{radialplot}{ThU}(x, from = NA, to = NA, t0 = NA,
  transformation = "log", show.numbers = FALSE, pch = 21,
  levels = NA, clabel = "", bg = c("yellow", "red"), col = "black",
  markers = NULL, k = 0, i2i = TRUE, alpha = 0.05, detritus = 0,
  hide = NULL, omit = NULL, omit.col = NA, ...)
}
\arguments{
\item{x}{Either an \code{[nx2]} matix of (transformed) values z
    and their standard errors s

OR

and object of class \code{fissiontracks}, \code{UThHe},
\code{ArAr}, \code{KCa}, \code{ReOs}, \code{SmNd}, \code{RbSr},
\code{LuHf}, \code{ThU}, \code{PbPb} or \code{UPb}}

\item{...}{additional arguments to the generic \code{points}
function}

\item{from}{minimum age limit of the radial scale}

\item{to}{maximum age limit of the radial scale}

\item{t0}{central value}

\item{transformation}{one of either \code{log}, \code{linear},
\code{sqrt} or \code{arcsin} (if \code{x} has class
\code{fissiontracks} and \code{fissiontracks$type} \eqn{\neq
1}).}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output.}

\item{show.numbers}{boolean flag (\code{TRUE} to show grain
numbers)}

\item{pch}{plot character (default is a filled circle)}

\item{levels}{a vector with additional values to be displayed as
different background colours of the plot symbols.}

\item{clabel}{label of the colour legend}

\item{bg}{Fill colour for the plot symbols. This can
    either be a single colour or multiple colours to form a colour
    ramp (to be used if \code{levels!=NA}):

\itemize{

\item{a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.}

\item{multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.}

\item{a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.}

\item{a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.}

\item{for plot symbols, set \code{bg=NA}}

}}

\item{col}{text colour to be used if \code{show.numbers=TRUE}}

\item{title}{add a title to the plot?}

\item{k}{number of peaks to fit using the finite mixture models of
Galbraith and Laslett (1993). Setting \code{k='auto'}
automatically selects an optimal number of components based on
the Bayes Information Criterion (BIC). Setting \code{k='min'}
estimates the minimum value using a three parameter model
consisting of a Normal distribution truncated by a discrete
component.}

\item{markers}{vector of ages of radial marker lines to add to the
plot.}

\item{alpha}{cutoff value for confidence intervals}

\item{units}{measurement units to be displayed in the legend.}

\item{hide}{vector with indices of aliquots that should be removed
from the radial plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the central age calculation or mixture models.}

\item{omit.col}{colour that should be used for the omitted
aliquots.}

\item{exterr}{propagate the external sources of uncertainty into
the mixture model errors?}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (type=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), or the (Wetherill) concordia age
(\code{type}=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{discordance cutoff filter. This is a three
    element list.

The first two items contain the minimum (negative) and maximum
(positive) percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U age
(if \eqn{^{206}}Pb/\eqn{^{238}}U < \code{cutoff.76}) or between the
\eqn{^{206}}Pb/\eqn{^{238}}U and \eqn{^{207}}Pb/\eqn{^{206}}Pb age
(if \eqn{^{206}}Pb/\eqn{^{238}}U > \code{cutoff.76}).

The third item is a boolean flag that controls whether the
discordance filter should be applied before (\code{TRUE}) or after
(\code{FALSE}) the common-Pb correction.

Set \code{cutoff.disc=NA} to turn off this filter.}

\item{common.Pb}{apply a common lead correction using one of three
    methods:

\code{1}: use the isochron intercept as the initial Pb-composition

\code{2}: use the Stacey-Kramers two-stage model to infer the initial
Pb-composition

\code{3}: use the Pb-composition stored in
\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')}}

\item{i2i}{`isochron to intercept': calculates the initial (aka
`inherited', `excess', or `common')
\eqn{^{40}}Ar/\eqn{^{36}}Ar, \eqn{^{40}}Ca/\eqn{^{44}}Ca,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{230}}Th/\eqn{^{232}}Th or \eqn{^{176}}Hf/\eqn{^{177}}Hf
ratio from an isochron fit. Setting \code{i2i} to \code{FALSE}
uses the default values stored in
\code{settings('iratio',...)}.}

\item{detritus}{detrital \eqn{^{230}}Th correction (only applicable
    when \code{x$format == 1} or \code{2}).

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus.

\code{3}: correct the data using the measured present day
\eqn{^{230}}Th/\eqn{^{238}}U, \eqn{^{232}}Th/\eqn{^{238}}U and
\eqn{^{234}}U/\eqn{^{238}}U-ratios in the detritus.}
}
\description{
Implementation of a graphical device developed by Rex Galbraith to
display several estimates of the same quantity that have different
standard errors.
}
\details{
The radial plot (Galbraith, 1988, 1990) is a graphical device that
was specifically designed to display heteroscedastic data, and is
constructed as follows.  Consider a set of dates
\eqn{\{t_1,...,t_i,...,t_n\}} and uncertainties
\eqn{\{s[t_1],...,s[t_i],...,s[t_n]\}}. Define \eqn{z_i = z[t_i]}
to be a transformation of \eqn{t_i} (e.g., \eqn{z_i = log[t_i]}),
and let \eqn{s[z_i]} be its propagated analytical uncertainty
(i.e., \eqn{s[z_i] = s[t_i]/t_i} in the case of a logarithmic
transformation). Create a scatterplot of \eqn{(x_i,y_i)} values,
where \eqn{x_i = 1/s[z_i]} and \eqn{y_i = (z_i-z_\circ)/s[z_i]},
where \eqn{z_\circ} is some reference value such as the mean. The
slope of a line connecting the origin of this scatterplot with any
of the \eqn{(x_i,y_i)}s is proportional to \eqn{z_i} and, hence,
the date \eqn{t_i}.  These dates can be more easily visualised by
drawing a radial scale at some convenient distance from the origin
and annotating it with labelled ticks at the appropriate
angles. While the angular position of each data point represents
the date, its horizontal distance from the origin is proportional
to the precision. Imprecise measurements plot on the left hand side
of the radial plot, whereas precise age determinations are found
further towards the right. Thus, radial plots allow the observer to
assess both the magnitude and the precision of quantitative data in
one glance.
}
\examples{
data(examples)
radialplot(examples$FT1)

dev.new()
radialplot(examples$LudwigMixture,k='min')
}
\references{
Galbraith, R.F., 1988. Graphical display of estimates
    having differing standard errors. Technometrics, 30(3),
    pp.271-281.

Galbraith, R.F., 1990. The radial plot: graphical assessment of
spread in ages. International Journal of Radiation Applications and
Instrumentation. Part D. Nuclear Tracks and Radiation Measurements,
17(3), pp.207-214.

Galbraith, R.F. and Laslett, G.M., 1993. Statistical models for
mixed fission track ages. Nuclear Tracks and Radiation
Measurements, 21(4), pp.459-470.
}
\seealso{
\code{\link{peakfit}}, \code{\link{central}}
}
