% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq.R
\name{diseq}
\alias{diseq}
\title{Set up U-series disequilibrium correction for U-Pb
    geochronology}
\usage{
diseq(option = 0, U48 = 1, Th0U8 = 1, Ra6U8 = 1, Pa1U5 = 1,
  fThU = 1, fRaU = 1, fPaU = 1)
}
\arguments{
\item{option}{one of four options:

\code{0}: no disequilibrium correction

\code{1}: use assumed initial activity ratios

\code{2}: use measured current activity ratios

\code{3}: use partition coefficients between the mineral and magma}

\item{U48}{the \eqn{^{234}}U/\eqn{^{238}}U-activity ratio (initial
if \code{option=1} or measured if \code{option=2}).}

\item{Th0U8}{the \eqn{^{230}}Th/\eqn{^{238}}U-activity ratio
(initial if \code{option=1} or measured if \code{option=2}).}

\item{Ra6U8}{the \eqn{^{226}}Ra/\eqn{^{238}}U-activity ratio
(initial if \code{option=1} or measured if \code{option=2}).}

\item{Pa1U5}{the \eqn{^{231}}Pa/\eqn{^{235}}U-activity ratio
(initial if \code{option=1} or measured if \code{option=2}).}

\item{fThU}{the Th/U fractionation factor between the mineral (m)
and the magma (M): \code{fThU} = (Th/U)\eqn{_m}/(Th/U)\eqn{_M}.}

\item{fRaU}{the Ra/U fractionation factor between the mineral (m)
and the magma (M): \code{fRaU} = (Ra/U)\eqn{_m}/(Ra/U)\eqn{_M}.}

\item{fPaU}{the Pa/U fractionation factor between the mineral (m)
and the magma (M): \code{fPaU} = (Pa/U)\eqn{_m}/(Pa/U)\eqn{_M}.}
}
\value{
a list with the following items: \code{option} and (\code{U48},
\code{Th08}, \code{Ra6U8}, \code{Pa1U8}) [if \code{option=1} or
\code{option=2}] and (\code{fThU}, \code{RaU}, \code{PaU}) [if
\code{option=3}].
}
\description{
The U-Pb method conventionally assumes initial secular
    equilibrium of all the intermediate daughters of the
    \eqn{{}^{238}}U-\eqn{{}^{206}}Pb and
    \eqn{{}^{235}}U-\eqn{{}^{207}}Pb decay chains.  Violation of
    this assumption may produce inaccurate results.  \code{diseq}
    sets up initial disequilibrium parameters that are subsequently
    passed on to the \code{read.data} function for incorporation in
    other functions.
}
\details{
There are three ways to correct for the initial disequilibrium
between the activity of \eqn{{}^{238}}U, \eqn{{}^{234}}Th,
\eqn{{}^{230}}Th, and \eqn{{}^{226}}Ra; or between \eqn{{}^{235}}U
and \eqn{{}^{231}}Pa:

\enumerate{

\item{Specify the assumed initial activity ratios and calculate how
much excess \eqn{{}^{206}}Pb and \eqn{{}^{207}}Pb these would have
produced. (Wendt and Carl, 1985).}

\item{Measure the current activity ratios to infer the initial
ratios.  This approach only works for young samples (< 5Ma, say).}

\item{Specify the elemental fractionation factor between Th and U
in the magma chamber and the mineral (Schaerer,
1984). \code{IsoplotR} generalises this approach to Ra/U and Pa/U
as well. However, it still assumes secular equilibrium between
\eqn{{}^{234}}U and \eqn{{}^{238}}Th.}

}
}
\examples{
d <- diseq(option=3,fThU=2)
fn <- system.file("UPb1.csv",package="IsoplotR")
UPb <- read.data(fn,method='U-Pb',format=1,d=d)
concordia(UPb)

}
\references{
Schaerer, U., 1984. The effect of initial \eqn{{}^{230}}Th
disequilibrium on young UPb ages: the Makalu case, Himalaya. Earth
and Planetary Science Letters, 67(2), pp.191-204.

Wendt, I. and Carl, C., 1985. U/Pb dating of discordant 0.1 Ma old
secondary U minerals. Earth and Planetary Science Letters, 73(2-4),
pp.278-284.
}
