% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/central.R
\name{central}
\alias{central}
\alias{central.default}
\alias{central.UThHe}
\alias{central.fissiontracks}
\title{Calculate U-Th-He and fission track central ages and compositions}
\usage{
central(x, ...)

\method{central}{default}(x, alpha = 0.05, ...)

\method{central}{UThHe}(x, alpha = 0.05, ...)

\method{central}{fissiontracks}(x, mineral = NA, alpha = 0.05, ...)
}
\arguments{
\item{x}{an object of class \code{UThHe} or \code{fissiontracks},
OR a 2-column matrix with (strictly positive) values and
uncertainties}

\item{...}{optional arguments}

\item{alpha}{cutoff value for confidence intervals}

\item{mineral}{setting this parameter to either \code{apatite} or
\code{zircon} changes the default efficiency factor, initial
fission track length and density to preset values (only affects
results if \code{x$format=2}.)}
}
\value{
if \code{x} has class \code{UThHe}, a list containing the
    following items:

\describe{
\item{age}{a four-element vector with:

\code{t}: the central age

\code{s[t]}: the standard error of \code{s[t]}

\code{ci[t]}: the \eqn{100(1-\alpha/2)\%} confidence interval for
\code{t} for the appropriate number of degrees of freedom

\code{disp[t]}: the \eqn{100(1-\alpha/2)\%} confidence interval
enhanced by a factor of \eqn{\sqrt{MSWD}}.
}

\item{mswd}{the reduced Chi-square statistic of data concordance,
i.e. \eqn{mswd=SS/df}, where \eqn{SS} is the sum of squares of
the log[U/He]-log[Th/He] compositions}

\item{df}{the degrees of freedom (\eqn{2n-2})}

\item{p.value}{the p-value of a Chi-square test with \code{df}
degrees of freedom}

\item{uvw}{(if the input data table contains Sm) or \strong{uv} (if
it doesn't): the geometric mean log[U/He], log[Th/He] (,
log[Sm/He]) and log[Sm/He] composition}

\item{covmat}{the covariance matrix of \code{uvw} or \code{uv}}

\item{tfact}{the \eqn{100(1-\alpha/2)\%} percentile of the t-
distribution for \code{df} degrees of freedom}

}

OR, otherwise:

\describe{

\item{age}{a three-element vector with:

\code{t}: the central age

\code{s[t]}: the standard error of \code{s[t]}

\code{ci[t]}: the \eqn{100(1-\alpha/2)\%} confidence interval for
\code{t} for the appropriate number of degrees of freedom }

\item{disp}{a two-element vector with the overdispersion (standard
deviation) of the excess scatter, and the corresponding
\eqn{100(1-\alpha/2)\%} confidence interval for the appropriate
degrees of freedom.}

\item{mswd}{the reduced Chi-square statistic of data concordance,
i.e. \eqn{mswd=X^2/df}, where \eqn{X^2} is a Chi-square statistic
of the EDM data or ages}

\item{df}{the degrees of freedom (\eqn{n-2})}

\item{p.value}{the p-value of a Chi-square test with \code{df}
degrees of freedom}

}
}
\description{
Computes the geometric mean composition of a set of fission track
or U-Th-He data and returns the corresponding age and fitting
parameters.
}
\examples{
data(examples)
print(central(examples$UThHe)$age)

}
\references{
Galbraith, R.F. and Laslett, G.M., 1993. Statistical
    models for mixed fission track ages. Nuclear tracks and
    radiation measurements, 21(4), pp.459-470.

Vermeesch, P., 2008. Three new ways to calculate average (U-Th)/He
    ages. Chemical Geology, 249(3), pp.339-347.
}
