% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakfit.R
\name{peakfit}
\alias{peakfit}
\alias{peakfit.default}
\alias{peakfit.fissiontracks}
\alias{peakfit.UPb}
\alias{peakfit.PbPb}
\alias{peakfit.ArAr}
\alias{peakfit.ReOs}
\alias{peakfit.SmNd}
\alias{peakfit.RbSr}
\alias{peakfit.LuHf}
\alias{peakfit.ThU}
\alias{peakfit.UThHe}
\title{Finite mixture modelling of geochronological datasets}
\usage{
peakfit(x, ...)

\method{peakfit}{default}(x, k = "auto", sigdig = 2, log = TRUE, ...)

\method{peakfit}{fissiontracks}(x, k = 1, exterr = TRUE, sigdig = 2,
  log = TRUE, ...)

\method{peakfit}{UPb}(x, k = 1, type = 4, cutoff.76 = 1100,
  cutoff.disc = c(-15, 5), exterr = TRUE, sigdig = 2, log = TRUE, ...)

\method{peakfit}{PbPb}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{ArAr}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = FALSE, ...)

\method{peakfit}{ReOs}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{SmNd}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{RbSr}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{LuHf}(x, k = 1, exterr = TRUE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{ThU}(x, k = 1, exterr = FALSE, sigdig = 2, log = TRUE,
  i2i = TRUE, ...)

\method{peakfit}{UThHe}(x, k = 1, sigdig = 2, log = TRUE, ...)
}
\arguments{
\item{x}{either a \code{[2 x n]} matrix with measurements and their
standard errors, or an object of class \code{fissiontracks},
\code{UPb}, \code{PbPb}, \code{ArAr}, \code{ReOs}, \code{SmNd},
\code{RbSr}, \code{LuHf}, \code{ThU} or \code{UThHe}}

\item{...}{optional arguments (not used)}

\item{k}{the number of discrete age components to be
sought. Setting this parameter to \code{'auto'} automatically
selects the optimal number of components (up to a maximum of 5)
using the Bayes Information Criterion (BIC).}

\item{sigdig}{number of significant digits to be used for any
legend in which the peak fitting results are to be displayed.}

\item{log}{take the logs of the data before applying the mixture
model?}

\item{exterr}{propagate the external sources of uncertainty into
the component age errors?}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), or the (Wetherill) concordia age (\code{type}=5)}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{two element vector with the maximum and minimum
percentage discordance allowed between the
\eqn{^{207}}Pb/\eqn{^{235}}U and \eqn{^{206}}Pb/\eqn{^{238}}U
age (if \eqn{^{206}}Pb/\eqn{^{238}}U < \code{cutoff.76}) or
between the \eqn{^{206}}Pb/\eqn{^{238}}U and
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (if
\eqn{^{206}}Pb/\eqn{^{238}}U > \code{cutoff.76}).  Set
\code{cutoff.disc=NA} if you do not want to use this filter.}

\item{i2i}{`isochron to intercept': calculates the initial
(aka `inherited', `excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os or
\eqn{^{176}}Hf/\eqn{^{177}}Hf ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}  or zero (for the Pb-Pb
method). When applied to data of class \code{ThU}, setting
\code{i2i} to \code{TRUE} applies a detrital Th-correction.}
}
\value{
a list with the following items: \describe{ \item{peaks}{a
    vector of peak locations} \item{props}{a vector of peak
    proportions} \item{peaks.err}{the standard errors of the peak
    locations} \item{props.err}{the standard errors of the peak
    proportions} \item{legend}{a vector of text expressions to be
    used in a figure legend} }
}
\description{
Implements the discrete mixture modelling algorithms of Galbraith
and Green (1993) and applies them to fission track and other
geochronological datasets.
}
\examples{
data(examples)
peakfit(examples$FT1,k=2)
}
\references{
Galbraith, R.F. and Laslett, G.M., 1993. Statistical
    models for mixed fission track ages. Nuclear tracks and
    radiation measurements, 21(4), pp.459-470.
}
