% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPb.R
\name{subset.UPb}
\alias{subset.UPb}
\title{Extract a group of samples from a U/Pb dataset}
\usage{
\method{subset}{UPb}(x, subset = NULL, select = NULL, ...)
}
\arguments{
\item{x}{a dataset of class 'UPb'}

\item{subset}{logical expression indicating elements or rows to
keep: missing values are taken as false.}

\item{select}{a vector of sample names}

\item{...}{optional arguments for the generic subset function}
}
\value{
an object of class 'UPb'
}
\description{
Returns a subset of U/Pb data matching a certain prefix
}
\examples{
fname <- system.file("UPb.csv",package="IsoplotR")
UPb <- read.UPb(fname)
#data(UPb)
ABC <- subset(UPb,select=c('A','B','C','D','E','F','G','H','I'))
concordia.plot(ABC,wetherill=TRUE)
}

