% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindTriples.R
\name{FindTriples}
\alias{FindTriples}
\title{Find "triples" of vector elements.}
\usage{
FindTriples(z)
}
\arguments{
\item{z}{Numeric vector}
}
\description{
\code{FindTriples} returns the number of left triples, right triples, and triples that are neither left nor right for the given vector.
}
\details{
Triples are formed by taking any three data values from a vector and order this triple of data values from 
smallest to largest. If the middle ordered item is closer to the smallest than to the largest, the triple is said
to be a right triple. If the middle ordered item is closer to the largest, the
triple is said to be a left triple. If the middle ordered value is exactly
halfway between the other two, the triple is neither right nor left. This function will do the necessary computations
and return the number of each type of triple.
}
\examples{
FindTriples(1:10)
FindTriples(rnorm(20))




\dontrun{
FindTriples("a")
}
}
