% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatpDs.R
\name{pSatD}
\alias{pSatD}
\title{Saturation Pressure, Function of Density}
\usage{
pSatD(D)
}
\arguments{
\item{D}{Density [ kg m-3]}
}
\value{
The first saturation pressure: pSat_1 [ MPa ]

The second saturation pressure: pSat_2 [ MPa ]

An Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{pSatD(D)} returns the saturation pressure [MPa], 
    pSat, for given D [ kg m-3 ]: it may have two different values!
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
D <- 890.341250
p_Sat <- pSatD(D)
p_Sat

D <- 999.887406
p_Sat <- pSatD(D)
p_Sat

}
