% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatpDs.R
\name{Dfs}
\alias{Dfs}
\title{Saturated Liquid Density, Function of Entropy}
\usage{
Dfs(s)
}
\arguments{
\item{s}{Entropy [kJ kg-1 K-1]}
}
\value{
The saturated Liquid density: Df [kg m-3] and an Error Message 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{Dfs(s)} returns the saturated liquid density [kg m-3], 
    Df, for given s [kJ kg-1 K-1].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
s <- 2.10865845
Df <- Dfs(s)
Df

}
