% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.res.R
\name{print.res}
\alias{print.res}
\title{Prints the output of estimateModel() function.}
\usage{
\method{print}{res}(x, ...)
}
\arguments{
\item{x}{A list containing the model estimation output, returned by
estimateModel() function.}

\item{...}{not used}
}
\value{
Prints the model estimation results of class res as a table that
shows the estimated model parameters and the corresponding 95% credible
interval lengths.
}
\description{
Prints the output of estimateModel() function.
}
\examples{
\donttest{
path1 <- system.file("extdata", "exampleInputData.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "exampleMesh.rda", package = "GeoAdjust")
load(path1)
load(path2)
nNodes = exampleMesh[['n']]
results <- estimateModel(data = exampleInputData, nNodes = nNodes,
options = list(random = 1, covariates = 1), priors = list(beta = c(0,1),
range = 114, USpatial = 1, alphaSpatial = 0.05, UNugget = 1, alphaNug = 0.05), n.sims = 1000)
print(results)
}
}
