% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridCountry.R
\name{gridCountry}
\alias{gridCountry}
\title{Creates a grid of locations within the bounding box of the national borders of a country of interest.}
\usage{
gridCountry(admin0 = NULL, res = NULL)
}
\arguments{
\item{admin0}{A SpatialPolygonsDataFrame object representing the national (admin0) level borders of the country.}

\item{res}{A value representing the resolution in kilometers.}
}
\value{
A list. The first element of the list, predRast, is the prediction raster. The second element of the list, loc.pred, is a data frame containing the grid of coordinates of the cell centers (both in degrees and in kilometers) of the prediction raster.
}
\description{
Creates a grid of locations within the bounding box of the national borders of a country of interest.
}
\examples{
\donttest{
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
grid <- gridCountry(admin0 = adm0, res = 5)
}
}
