% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{get_latest_release}
\alias{get_latest_release}
\title{Get the Latest Gencode Release Dynamically}
\usage{
get_latest_release(species, verbose = TRUE)
}
\arguments{
\item{species}{A character string indicating the species. Supported values are:
\itemize{
\item "human"
\item "mouse"
}}

\item{verbose}{Logical. If TRUE (default), the function prints the latest release.}
}
\value{
A character string representing the latest release version for the specified
species (e.g., "release_42" for human or "release_36" for mouse).
}
\description{
This function retrieves the latest available release of the Gencode database
for a given species (human or mouse) by querying the relevant FTP directory.
It automates the process of identifying the latest release of annotations for human or mouse.
}
\details{
The function accesses the GENCODE FTP directory and parses the available folders to determine the latest release.
It is particularly useful for bioinformatics workflows that require up-to-date annotation files without manual checks.
}
\examples{
\dontrun{
# Retrieve the latest release version for human
human_release <- get_latest_release(species = "human", verbose = FALSE)
cat("Latest human GENCODE release: release_47")

# Get the latest release for mouse
mouse_release <- get_latest_release("mouse", verbose = TRUE)
}

}
