% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnPlotNetwork.R
\name{gsnPlotNetwork}
\alias{gsnPlotNetwork}
\title{gsnPlotNetwork}
\usage{
gsnPlotNetwork(
  object,
  pathways_dat = NULL,
  distance = NULL,
  id_col = NULL,
  substitute_id_col = NULL,
  stat_col = NULL,
  stat_col_2 = NULL,
  sig_order = NULL,
  sig_order_2 = NULL,
  n_col = NULL,
  optimal_extreme = NULL,
  transform_function = nzLog10,
  pathways_title_col = c("Title", "Name", "NAME", "STANDARD_NAME"),
  edge_colors = c("black", "purple", "blue", "green", "yellow4", "orange", "red"),
  vertex_colors = c("white", "yellow", "red"),
  vertex_colors.1 = c("white", "red"),
  vertex_colors.2 = c("white", "blue"),
  combine_method = "scaled_geomean",
  na.color = "#CCCCCC",
  filename = NULL,
  out_format = NULL,
  width = NULL,
  height = NULL,
  vertex.shape = "circle",
  vertex.size = NULL,
  vertex.size.range = NULL,
  vertex.label.cex = NULL,
  vertex.label.col = NULL,
  vertex.frame.color = par("fg"),
  contrasting_color.fun = NULL,
  scale_labels_by_vertex = TRUE,
  max_edge_width = NULL,
  scale.edges.by.distance = FALSE,
  color.edges.by.distance = FALSE,
  edge_arrow_size = NULL,
  seed = 29189892,
  layout = function(x) {
     igraph::layout_with_fr(x, grid = "nogrid")
 },
  .plot = igraph::plot.igraph,
  show.legend = TRUE,
  legend.lab.cex = NULL,
  legend.axis.cex = NULL,
  legend.fg = par("fg"),
  legend.bg = "#DDDDDD",
  legend.vertex.fg = NULL,
  legend.vertex.bg = "#DDDDDD",
  font_face = par("family"),
  main = NULL,
  cex.main = NULL,
  mar.main = 3.2,
  lines.main = 0.9,
  .mar.plot = NULL,
  draw.legend.box.bool = FALSE,
  legend.free.cex.bool = FALSE,
  legend_x_size.in = NULL,
  colors.n = 100,
  new = FALSE,
  legend_spacing.x.in = 2 * par("cin")[1],
  legend_spacing.y.in = par("cin")[2],
  resolution = 72,
  DO_BROWSER = FALSE
)
}
\arguments{
\item{object}{A GSNData object containing a pared distance matrix with \code{edges}. NOTE: when calling as
\code{plot.GSNData}, use the argument \code{x} instead.}

\item{pathways_dat}{(optional) data.frame containing associated pathways data. This defaults to whatever pathways
data has already been imported into this GSNData object in \code{object$pathways$data}.}

\item{distance}{(optional) The name of a distance metric used, defaults to whatever \code{default_distance} is.}

\item{id_col}{(optional) This is the name of the column in the pathways data.frame that corresponds to the names of
gene sets. The default value is specified by \code{object$pathways$id_col}. (See details.)}

\item{substitute_id_col}{(optional) This is the name of the column that is to be substituted for the \code{id_col}
column when labeling network vertices. (See details.)}

\item{stat_col}{(optional) This is the name of the column in the pathways data.frame that contains a significance
value for coloring network vertices. The default value is specified by \code{object$pathways$stat_col}.}

\item{stat_col_2}{(optional) This is the name of an optional second column in the pathways data.frame that
contains a significance value for coloring network vertices in a 2-color network. The default value is specified
by \code{object$pathways$stat_col_2}. When specified, a 2-color network is generated. To force a 2-color network
to plot as a standard 1-color network using \code{stat_col} alone, use \code{stat_col_2 = NA}.}

\item{sig_order}{(optional) This indicates the behavior of \code{stat_col}, whether low values (\code{'loToHi'}) or
high values (\code{'hiToLo'}) are most significant. The default value is specified in \code{object$pathways$sig_order}.}

\item{sig_order_2}{(optional) This indicates the behavior of \code{stat_col_2}, whether low values (\code{'loToHi'}) or
high values (\code{'hiToLo'}) are most significant. The default value is specified in \code{object$pathways$sig_order_2}.}

\item{n_col}{(optional) This is the name of the column in the pathways data.frame that contains a value for gene set
size, or any other value intended to be the bases of leaf scaling. When specified, leaf sizes will be scaled by this
value, either as a function argument, or in the \code{object$pathways$n_col} field. An \code{NA} value can be used
to override the the value in \code{object$pathways$n_col} and suppress leaf scaling when \code{n_col} has been
set in the object. (default is the value in \code{object$pathways$n_col}).}

\item{optimal_extreme}{(optional) This indicates the behavior of the statistic used to generate the distance metric,
specifically whether low values (\code{'min'}) or high values \code{'max'} are to be regarded as close. This is used
for scaling the width and the color of the edges connecting vertices. See \code{scale.edges.by.distance}, below:
(default: object$distances[\link{distance}]$pared_optimal_extreme or if that's NULL,
object$distances[\link{distance}]$optimal_extreme)}

\item{transform_function}{(optional) This is a function to transform the values in \code{stat_col} so that they
are suitable for amenable to color-scaling. For \emph{p}-values, a log transformation is often useful, but can produce
negative infinities if the transformation is applied to zero. By default the function is the \code{nzLog10}
(non-zero log10) function, provided by this package, which adds a small pseudocount to p-values when log10 transforming
values equal to zero. If values in \code{stat_col} are less than zero, then log10 transformation is inappropriate and
will introduce NAs, and therefore some other method should be used. (default: \code{nzLog10})}

\item{pathways_title_col}{(optional) Indicates a column to be used as the 'Title' column for network vertices.
If unset, the function attempts to search for a title column from the following values: c("Title", "Name", "NAME",
"STANDARD_NAME" ) (See details.)}

\item{edge_colors}{(optional) A vector of colors included to generate a scale represent the numerical value of the
edge distances. By default, the colors are arranged as a rainbow with black and purple representing the greatest
distances, and orange and red the nearest distances. This feature (and argument) will likely be deprecated in
future versions. (default: edge_colors = c("black", "purple", "blue", "green","yellow4", "orange","red"))}

\item{vertex_colors}{(optional) This is the standard set of colors used for a standard single color network.
By default, c("white","yellow","red") is used, coloring low values white, high values red, and intermediate values
yellow if \code{sig_order} is "loToHi" and vice versa if sig_order is "hiToLo".}

\item{vertex_colors.1}{(optional) This is the range of colors used for a 2-color network corresponding to
values of \code{stat_col}. Up to 2 colors can be used, and should correspond to a color contrasting with
\code{vertex_colors.2}. The default is c("white","red"), coloring high values red and low values white if
\code{sig_order} is \code{"loToHi"} and vice versa if \code{sig_order} is \code{"hiToLo"}.}

\item{vertex_colors.2}{(optional) This is the range of colors used for a 2-color network corresponding to
values of \code{stat_col_2}. Up to 2 colors can be used, and should correspond to a color contrasting with
\code{vertex_colors.2}. The default is \code{c("white","blue")}, coloring high values blue and low values white
if \code{sig_order_2} is \code{"loToHi"} and vice versa if \code{sig_order} is \code{"hiToLo"}.}

\item{combine_method}{(optional) For dual channel plots this is a string used to indicate how colors are combined to
generate a two dimensional color scale. Options are "scaled_geomean" (same as "default"), "standard" (same as "euclidean" ),
"negative_euclidean", "mean", and "additive". See details.}

\item{na.color}{(optional) This color is assigned to vertices for which there is an \code{NA} value. (default: "#CCCCCC")}

\item{filename}{(optional) An output file name for the plot. If 'out_format' is not set (see below), the output
file type will be determined by the file suffix, which can be \code{'.svg'}, \code{'.pdf'}, or \code{'.png'}. If
the \code{out_format} cannot be determined from the file name, than it may be manually set with \code{out_format}.
If the output file type cannot be determined from the \code{filename} or \code{out_format} arguments, an error will
be thrown.}

\item{out_format}{(optional) Output filetype when \code{filename} is specified, either \code{'svg'}, \code{'png'},
\code{'pdf'}, or \code{'plot'} (default if filename is not specified). For more information, see Details.}

\item{width}{(optional) Sets the width of the output canvas in inches. Defaults to the width of the present
graphical device.}

\item{height}{(optional) Sets the height of the output canvas in inches. Defaults to the height of the present
graphical device.}

\item{vertex.shape}{(optional) Shape of the vertex, passed to \code{igraph::plot.igraph}. By default, the value is
\code{'circle'}.}

\item{vertex.size}{(optional) Size of vertices, passed to \code{igraph::plot.igraph}. By default, the value is
NULL, and the function attempts to pick a reasonable value based on the canvas size and the number of gene sets.}

\item{vertex.size.range}{(optional) The range of vertex sizes used in plots, from low to high. This is used when
\code{n_col} is specified and vertex sizes are intended to be scaled. If this is not specified, then the function
attempts to select appropriate values based on size of the figure being generated.}

\item{vertex.label.cex}{(optional) Size of vertex labels, passed to \code{igraph::plot.igraph}. As with vertex.size,
by default, the value is NULL, and the function attempts to pick a reasonable value based on the canvas size and
the number of gene sets.}

\item{vertex.label.col}{(optional) Color of vertex labels, passed to \code{igraph::plot.igraph}. If not specified,
the function attempts to pick a contrasting color for vertex label text using the \code{contrasting_color.fun}
argument. (default: NULL)}

\item{vertex.frame.color}{(optional) Color of the vertex border. (default par('fg'))}

\item{contrasting_color.fun}{(optional) A function to pick a color for vertex labels that contrasts with the vertex
fill color. If unspecified, the function attempts to pick a suitable function for generating suitable set of contrasting
colors, based on the \code{contrasting_color()} function. (default: For single channel plots using color scales defined
with \code{vertex_colors}, or dual channel color scales defined with \code{vertex_colors.1}, or \code{vertex_colors.2}
using yellow or orange, \code{contrasting_color(type="binary")} is used, and otherwise
\code{contrasting_color(type="blackyellow")} is used.)}

\item{scale_labels_by_vertex}{(optional) Logical that tells the function to scale the text in vertex labels by the size
of the vertex. (default: TRUE)}

\item{max_edge_width}{(optional) Size of vertex labels, passed to \code{igraph::plot.igraph}. By default, the value
is NULL, and the function attempts to pick a reasonable value based on the canvas size and the number of gene sets.}

\item{scale.edges.by.distance}{(optional) A logical telling the function to scale edges between vertices on the basis
of distance. NOTE: If \code{optimal_extreme == "max"}, then smaller numbers are treated as more distant, and conversely
if \code{optimal_extreme == "min"}, larger numbers are treated as more distant. (default: FALSE)}

\item{color.edges.by.distance}{(optional)  A logical telling the function to color edges between vertices on the basis
of distance. This functionality will likely be deprecated. (default: FALSE)}

\item{edge_arrow_size}{(optional) Size of vertex labels, passed to \code{igraph::plot.igraph}. By default, the value
is NULL, and the function attempts to pick a reasonable value based on the canvas size and the number of gene sets.}

\item{seed}{(optional) This is a seed that the function uses to generate a plot layout. By default it is 29189892,
and this results in a repeatable behavior for plots. However, to randomize the plot layout behavior, this value may
be set to NULL, or if some other repeatable layout is desired, another seed may be used.}

\item{layout}{(optional) Either a function that generates a layout or a numerical matrix containing a vertex layout
with two columns corresponding to \emph{x} and \emph{y} coordinates. This argument is passed to the \code{igraph} plot method
that is subsequently called by \code{gsnPlotNetwork()} (see \code{.plot}, below). The default \code{layout} is
the anonymous function \code{function(x){igraph::layout_with_fr(x, grid = "nogrid" )}}, which calls
\code{igraph::layout_with_fr()} (implementing Fruchterman-Reingold layout) with the \code{grid="nogrid"} option,
enabling proper layout of networks with >= 1000 gene set vertices. Other useful layouts for \code{igraph} networks
include \code{igraph::layout_with_fr} (default Fruchterman-Reingold), \code{igraph::layout_with_dh} (implementing
Davidson-Harel layout), \code{igraph::layout_as_tree}, \code{igraph::layout_nicely}, and others.
For more details about layouts, see \code{\link[igraph]{igraph.plotting}}.}

\item{.plot}{(optional) A plot function used to render the internally generated \code{igraph} object. By default
\code{igraph::plot.igraph} is used, but for interactive plotting, \code{igraph::tkplot} may be used. For more
details about plotting, see \code{\link[igraph]{igraph.plotting}}.}

\item{show.legend}{(optional) A logical value telling the function whether or not to show legends. Legends for vertex
size and node color are currently supported. (default: TRUE)}

\item{legend.lab.cex}{(optional) The font size of legend label text as cex units. If not specified, the function will
attempt to pick an appropriate value based on the figure layout.}

\item{legend.axis.cex}{(optional) The font size of legend axis text as cex units. If not specified, the function will
attempt to pick an appropriate value based on the figure layout.}

\item{legend.fg}{(optional) The foreground color of the legend that controls the color of text, axes, axis labels,
ticks, and legend border. (default: par('fg'))}

\item{legend.bg}{(optional) The background color of the legend. This argument doesn't currently work, and may be
removed in the future. (default: "#CCCCCC" )}

\item{legend.vertex.fg}{(optional) The border color of vertices for vertex size legends. This argument allows the
legend vertex frame color to be set separately from vertex.frame.color. (default: vertex.frame.color)}

\item{legend.vertex.bg}{(optional) The fill color of vertices for vertex size legends. (default: "#DDDDDD")}

\item{font_face}{(optional) The font face used for the figure. (default: par("family"))}

\item{main}{(optional) The plot title. (default: NULL)}

\item{cex.main}{(optional) The font size in cex units of the main title. (default: 1.5 * par( 'cex' ))}

\item{mar.main}{(optional) The number of lines set aside for a main title when main is used. (default: 3.2)}

\item{lines.main}{(optional) The distance of the main title in lines from the top of the plot. (default: 0.9)}

\item{.mar.plot}{(optional) The margins of the plot itself. If unspecified, the function will attempt to reserve
enough room to the right of the plot for the legend or legends.}

\item{draw.legend.box.bool}{(option) Logical indicating whether bounding boxes should be drawn for the legends.}

\item{legend.free.cex.bool}{(optional) Logical allowing independent optimized sizing of legend label font sizes if TRUE.
(default: FALSE)}

\item{legend_x_size.in}{(optional) The width of the legend in inches. If not set, the function attempts to choose an
appropriate value. (default: \code{min(2,max(width*2/5,width-height))})}

\item{colors.n}{(optional) The number of colors in for each channel in 1 or 2 channel plots. For single channel plots
the number of colors is simply equal to this number. For dual channel plots the total number of colors in the legend
is equal to the square of this number. (default: 100)}

\item{new}{(optional) Logical telling the function (if true) that a new plot should be added to an existing device (if
TRUE) or that the current device should be cleared and written over (if FALSE). (default: FALSE)}

\item{legend_spacing.x.in}{(optional) Space between plot and legend in inches. This can be used to adjust the horizontal
position and move the legend closer to or farther away from the plot region. Since the network plot may not fill the
entire plotting region, it may be useful to use negative values to move the legends closer to the plot.
(default: 2 character widths)}

\item{legend_spacing.y.in}{(optional) Space between legends in inches. (default: 1 character height)}

\item{resolution}{Image resolution in pixels per inch, only for bitmap image output formats (currently
png only). (default: 72)}

\item{DO_BROWSER}{(option) Logical indicating whether browser() should be run for this function. (For debugging
purposes, will probably remove.)}
}
\value{
An \code{igraph} network object is returned, invisibly.
}
\description{
Function for plotting the networks within GSNData objects.
}
\details{
This function is primarily for taking \code{GSNData} object containing a distance matrix, an associated
\code{edges} edge-list and pathways data, and generating and rendering a corresponding \code{igraph} object. The
function attempts to plot the corresponding network with vertices labeled with a gene set \code{ID} and corresponding
\code{Title}, and colored according to the significance values represented in \code{stat_col} using \code{sig_order}
as an indicator of whether high or low values are more significant. Edges are scaled by the value of the value of the
distance statistic in the pared distance matrix.

When the parameters \code{vertex.shape}, \code{vertex.size}, \code{vertex.label.cex}, \code{max_edge_width}, and
\code{edge_arrow_size} are not specified, the function attempts to pick reasonable values. These parameters are
assembled into a list and attached to the returned \code{igraph} object as an attribute named \code{GSNA_plot_params}.
To optimize plots, the user can examine these parameters by calling the following on the output of the function:

\code{attr( x = nw.igraph, which = "GSNA_plot_params" )}
}
\examples{

\donttest{
# This example can take >10 seconds to run on some platforms,
# so we won't test it here.

library(GSNA)

# In this example, we generate a gene set network from CERNO example
# data. We begin by subsetting the CERNO data for significant results:
sig_pathways.cerno <- subset( Bai_CiHep_DN.cerno, adj.P.Val <= 0.05 )

# Now create a gene set collection containing just the gene sets
# with significant CERNO results, by subsetting Bai_gsc.tmod using
# the gene set IDs as keys:
sig_pathways.tmod <- Bai_gsc.tmod[sig_pathways.cerno$ID]

# And obtain a background gene set from differential expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Build a gene set network:
sig_pathways.GSN <-
   buildGeneSetNetworkJaccard(geneSetCollection = sig_pathways.tmod,
                              ref.background = background_genes )

# Now import the CERNO data:
sig_pathways.GSN <- gsnImportCERNO( sig_pathways.GSN,
                                    pathways_data = sig_pathways.cerno )

# Now we can pare the network and assign subnets:
sig_pathways.GSN <- gsnPareNetGenericHierarchic( object = sig_pathways.GSN )
sig_pathways.GSN <- gsnAssignSubnets( sig_pathways.GSN )

# Now, produce a network plot:
gsnPlotNetwork( object  = sig_pathways.GSN )
}

}
\seealso{
\code{\link{plot.GSNData}}
\code{\link{gsnToIgraph}}
\code{\link[igraph]{plot.igraph}}
}
