% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POLMM.R
\name{GRAB.POLMM}
\alias{GRAB.POLMM}
\title{POLMM method in GRAB package}
\usage{
GRAB.POLMM()
}
\value{
No return value, called for side effects (prints information about the POLMM method to the console).
}
\description{
POLMM method is to analyze ordinal categorical data for related samples in a large-scale biobank.
}
\details{
Please check \code{?GRAB.control} for the generic list of \code{control} in \code{GRAB.NullModel()} and \code{GRAB.Marker()}.

Additional list of \code{control} in \code{GRAB.NullModel()} function
Additional list of \code{control} in \code{GRAB.Marker()} function
Additional list of \code{control} in \code{GRAB.Region()} function
}
\examples{
### First, read phenotype data and convert to a factor
PhenoFile <- system.file("extdata", "simuPHENO.txt", package = "GRAB")
PhenoData <- data.table::fread(PhenoFile, header = TRUE)
PhenoData$OrdinalPheno <- factor(PhenoData$OrdinalPheno, levels = c(0, 1, 2))

### Step 1: Fit a null model
# If SparseGRMFile is provided, the sparse GRM will be used in model fitting.
# If SparseGRMFile isn't provided, GRAB.NullModel() will calculate dense GRM from GenoFile.
SparseGRMFile <- system.file("extdata", "SparseGRM.txt", package = "GRAB")
GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")

obj.POLMM <- GRAB.NullModel(
  formula = OrdinalPheno ~ AGE + GENDER,
  data = PhenoData,
  subjData = PhenoData$IID,
  method = "POLMM",
  traitType = "ordinal",
  GenoFile = GenoFile,
  SparseGRMFile = SparseGRMFile,
  control = list(
    showInfo = FALSE,
    LOCO = FALSE,
    tolTau = 0.2,
    tolBeta = 0.1
  )
)

### Step 2(a): Single-variant tests using POLMM
GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
OutputFile <- file.path(tempdir(), "simuMarkerOutput.txt")

GRAB.Marker(
  objNull = obj.POLMM,
  GenoFile = GenoFile,
  OutputFile = OutputFile
)

data.table::fread(OutputFile)

### Step 2(b): Set-based tests using POLMM-GENE
GenoFile <- system.file("extdata", "simuPLINK_RV.bed", package = "GRAB")
OutputFile <- file.path(tempdir(), "simuRegionOutput.txt")
GroupFile <- system.file("extdata", "simuPLINK_RV.group", package = "GRAB")
SparseGRMFile <- system.file("extdata", "SparseGRM.txt", package = "GRAB")

GRAB.Region(
  objNull = obj.POLMM,
  GenoFile = GenoFile,
  GenoFileIndex = NULL,
  OutputFile = OutputFile,
  OutputFileIndex = NULL,
  GroupFile = GroupFile,
  SparseGRMFile = SparseGRMFile,
  MaxMAFVec = "0.01,0.005"
)

data.table::fread(OutputFile)

}
