% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ts.bin.studyend.GNG.hm.df.r
\name{return.ts.bin.studyend.GNG.hm.df}
\alias{return.ts.bin.studyend.GNG.hm.df}
\title{Return two-sample binary study end GNG heatmap data.frame}
\usage{
return.ts.bin.studyend.GNG.hm.df(
  a.con = 1,
  b.con = 1,
  n.con = 30,
  a.trt = 1,
  b.trt = 1,
  n.trt = 30,
  Delta.lrv = 0.3,
  Delta.tv = 0.4,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  x_ng = NULL,
  x_go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8
)
}
\arguments{
\item{a.con}{prior alpha parameter for control group}

\item{b.con}{prior beta parameter for control group}

\item{n.con}{sample size for control group}

\item{a.trt}{prior alpha parameter for treatment group}

\item{b.trt}{prior beta parameter for treatment group}

\item{n.trt}{sample size for control treatment group}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{x_ng}{responses needed for no-go; leave null for standard rule}

\item{x_go}{responses needed for go; leave null for standard rule}

\item{go.thresh}{go threshold for predictive probability}

\item{ng.thresh}{no-go threshold for predictive probability}
}
\value{
A data.frame is returned
}
\description{
Return two-sample binary study end GNG heatmap data.frame
}
\examples{
my.ts.bin.studyend.GNG.hm.df <- return.ts.bin.studyend.GNG.hm.df()
head(my.ts.bin.studyend.GNG.hm.df)
}
