% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return.ss.ng.int.data.req.r
\name{return.ss.ng.int.data.req}
\alias{return.ss.ng.int.data.req}
\title{Return single sample normal-gamma predictive probability}
\usage{
return.ss.ng.int.data.req(
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  xbar.t = seq(-5, 5, 0.1),
  s.t = 2,
  interim.n.t = c(5, 10, 15, 20, 25, 30, 35),
  final.n.t = 40,
  Delta.lrv = 1.25,
  Delta.tv = 1.75,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  xbar_ng = NULL,
  xbar_go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8
)
}
\arguments{
\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{xbar.t}{sample mean for treatment group}

\item{s.t}{sample sd for treatment group}

\item{interim.n.t}{interim sample size}

\item{final.n.t}{final sample size}

\item{Delta.lrv}{Min TPP}

\item{Delta.tv}{Base TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{xbar_ng}{xbar for no-go; leave null for standard rule}

\item{xbar_go}{xbar for go; leave null for standard rule}

\item{go.thresh}{go threshold for predictive probability}

\item{ng.thresh}{no-go threshold for predictive probability}
}
\value{
A data.frame is returned
}
\description{
Return single sample normal-gamma predictive probability
}
\examples{
{
my.ss.ng.int.data.req <- return.ss.ng.int.data.req()
head(my.ss.ng.int.data.req)
}
}
