% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.bin.ssize.oc.df.r
\name{get.ts.bin.ssize.oc.df}
\alias{get.ts.bin.ssize.oc.df}
\title{Get two-sample binary sample size OC data.frame}
\usage{
get.ts.bin.ssize.oc.df(
  a.con = 1,
  b.con = 1,
  a.trt = 1,
  b.trt = 1,
  dcurve.con = 0.12,
  Aratio = 2,
  SS.OC.N.LB = 40,
  SS.OC.N.UB = 160,
  Delta.lrv = 0.2,
  Delta.tv = 0.25,
  SS.OC.Delta = 0.25,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  npoints = 3
)
}
\arguments{
\item{a.con}{prior alpha parameter for control group}

\item{b.con}{prior beta parameter for control group}

\item{a.trt}{prior alpha parameter for treatment group}

\item{b.trt}{prior beta parameter for treatment group}

\item{dcurve.con}{underlying rate for control group}

\item{Aratio}{randomization ratio}

\item{SS.OC.N.LB}{lower bound for sample size}

\item{SS.OC.N.UB}{upper bound for sample size}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{SS.OC.Delta}{user's treatment effect}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{npoints}{number of points}
}
\value{
returns a data.frame ready to create two-sample binary sample size operating characteristics curve
}
\description{
Get two-sample binary sample size OC data.frame
}
\examples{
\donttest{
my.ts.bin.ssize.oc.df <- get.ts.bin.ssize.oc.df()
}
}
\author{
Greg Cicconetti
}
