% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{fitVAR}
\alias{fitVAR}
\title{Fit VAR Model with Elastic Net via Cross Validation}
\usage{
fitVAR(data, p = 1, needReproduce = FALSE, ...)
}
\arguments{
\item{data}{A numeric matrix or data frame with time series data (observations in rows,
variables in columns).}

\item{p}{Integer. The order of the VAR model.}

\item{...}{Additional options for estimation. Global options include:
\itemize{
  \item \code{threshold}: Logical. If \code{TRUE}, all entries smaller than the oracle
        threshold are set to zero.
  \item \code{scale}: Logical. Whether to scale the data (default is \code{FALSE}).
  \item \code{nfolds}: Integer. The number of folds used for cross validation (default is 10).
  \item \code{parallel}: Logical. If \code{TRUE}, use multicore backend (default is \code{FALSE}).
  \item \code{ncores}: Integer. If \code{parallel = TRUE}, specify the number of cores to use.
  \item \code{alpha}: Numeric. The elastic net mixing parameter (default is 1, i.e. LASSO).
  \item \code{type.measure}: Character. The error measure for CV (e.g., \code{"mse"} or \code{"mae"}).
  \item \code{nlambda}: Integer. The number of lambda values to use in cross validation (default is 100).
  \item \code{leaveOut}: Integer. In time slice validation, leave out the last observations (default is 15).
  \item \code{horizon}: Integer. The forecast horizon to use for estimating error (default is 1).
  \item \code{lambda}: Either a numeric vector of lambda values or a string indicating which
        lambda to use (default is \code{"lambda.min"}).
  \item \code{return_fit}: Logical. If \code{TRUE}, return the complete fit object.
}}
}
\value{
A list with the following components:
  \item{mu}{A vector of means for each variable.}
  \item{A}{A list (of length \code{p}) of the estimated coefficient matrices for the VAR process.}
  \item{fit}{(Optional) The complete results of the penalized least squares estimation.}
  \item{lambda}{The chosen lambda value (by cross validation).}
  \item{mse}{The minimum mean squared error from cross validation.}
  \item{mse_sd}{The standard deviation of the mean squared error.}
  \item{time}{Elapsed time for the estimation.}
  \item{series}{The (possibly transformed) input time series.}
  \item{residuals}{The residuals of the VAR model.}
  \item{sigma}{The estimated variance/covariance matrix of the residuals.}
}
\description{
Estimates a (possibly high-dimensional) VAR model using penalized least squares
with an elastic net penalty and cross validation.
This function is adapted from the \emph{sparsevar} package
(<https://github.com/svazzole/sparsevar/tree/master>), which is distributed under
the GNU General Public License v2. The code has been modified to specifically implement
the elastic net penalty (penalty = "ENET") and cross validation (method = "cv").
}
\references{
The original source code is adapted from the
  \href{https://github.com/svazzole/sparsevar/tree/master}{sparsevar package},
  which is distributed under the GNU General Public License v2.
}
\keyword{internal}
