% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/l_regression.R
\name{laplacegaussnorm}
\alias{laplacegaussnorm}
\title{Laplace-Gauss Normal Distribution Object}
\usage{
laplacegaussnorm(X)
}
\arguments{
\item{X}{vector of quantiles.}
}
\value{
\item{dfrXPn}{data.frame. X = initial quantiles. Pn = estimated normal probabilites.}
\item{dfrXLn}{data.frame. X = initial quantiles. Ln = logit of estimated normal probabilites.}
\item{dfrXDn}{data.frame. X = initial quantiles. Dn = estimated normal density.}
\item{coefn}{numeric. The mean and the standard deviation of the dataset.}
\item{dfrQnPn}{data.frame. Qn = estimated quantiles of interest. Pn = probability.}
\item{dfrQnPn}{data.frame. Qn = estimated quantiles of interest. Pn = logit of probability.}
}
\description{
An object designed after regkienerLX to summarize the information related to
a given dataset when the Laplace-Gauss normal distribution is applied on it.
}
\details{
This function is designed after regkienerLX to provide a
              similar framework.
}
\examples{
prices2returns <- function(x) { 100*diff(log(x)) }
CAC  <- prices2returns(as.numeric(EuStockMarkets[,3]))
lgn  <- laplacegaussnorm( CAC )
attributes(lgn)
head(lgn$dfrXPn)
head(lgn$dfrXLn)
head(lgn$dfrXDn)
lgn$coefn
lgn$dfrQnPn
lgn$dfrQnLn
}
\seealso{
The regression function \code{\link{regkienerLX}}.
}

