% Generated by roxygen2 (4.0.1): do not edit by hand
\name{logit}
\alias{invlogit}
\alias{logit}
\title{Logit Function}
\usage{
logit(p)

invlogit(x)
}
\arguments{
\item{p}{a numeric value or vector.}

\item{x}{a numeric value or vector.}
}
\description{
The logit function, widely used in this package, is a wrapper of
\code{\link{qlogis}}.

The invlogit function is the inverse of the logit function and a
wrapper of \code{\link{plogis}}.
}
\details{
\code{logit} function is defined for p in (0, 1) by:
              \deqn{ logit(p) = log( p/(1-p) ) }

\code{invlogit} function is defined for x in (-Inf, +Inf) by:
              \deqn{ invlogit(x) = exp(x)/(1+exp(x)) = plogis(x) }
}
\examples{
logit( c(ppoints(11, a = 1), NA, NaN) )
invlogit( c(-Inf, -10:10, +Inf, NA, NaN) )
}
\seealso{
The equivalent function \code{\link{qlogis}}.

The equivalent function \code{\link{plogis}}.
}

