% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{dfData}
\alias{dfData}
\title{Datasets dfData, tData, xData, zData.}
\description{
A list of 10 financial series in data.frame, timeSeries, xts and zoo formats
used in the document presented at 8th and 9th Rmetrics conferences (2014, 2015).
See references. The datasets include dates and prices.
All distributions of the returns exhibit fat tails.
The last one (CHF, interest rates in Switzerland) exhibits negative prices!
}
\details{
A list of 10 financial series presented in four different formats for
convenient use: dfData, tData, xData and zData are respectively of
data.frame format (with dates as row.names), timeSeries, xts and zoo formats.
dfData is the complete dataset whereas tData, xData and zData display are subsets
and display one column per stock.
\enumerate{
  \item{ 1: "Gold" from 1999-01-04 to 2013-12-31, dim 3694x1 (df, t, x, z). }
  \item{ 2: "Dexia" from 2008-10-27 to 20009-10-26, dim 255x5 (df), dim 255x1 (t, x, z). }
  \item{ 3: "SocGen" from 1992-07-20 to 2013-12-31, dim 5445x5 (df), dim 5445x1 (t, x, z). }
  \item{ 4: "Vivendi" from 1992-07-20 to 2013-12-31, dim 5444x5 (df), dim 5444x1 (t, x, z). }
  \item{ 5: "Eurodollar" from 1999-01-03 to 2013-12-31, dim 3843x4 (df), dim 3843x1 (t, x, z). }
  \item{ 6: "VIX" from 2004-01-02 to 2013-12-31, dim 2517x4 (df), dim 2517x1 (t, x, z). }
  \item{ 7: "CAC40" from 1988-01-04 to 2013-12-31, dim 6574x4 (df), dim 6574x1 (t, x, z). }
  \item{ 8: "DJIA" from 1896-05-26 to 2013-12-31, dim 32064x1 (df, t, x, z). }
  \item{ 9: "SP500" from 1957-01-02 to 2013-12-31, dim 14350x1 (df, t, x, z). }
  \item{10: "CHF" from 1995-01-02 to 2013-09-13, dim 4880x8 (df), dim 4880x1 (t, x, z).
            Include negative prices (interest rates) at the end of the dataset.
            Care is required to calculate the returns! }
}
}
\examples{
require(timeSeries)
require(xts)
attributes(dfData); attributes(tData); attributes(xData); attributes(zData)
for (j in 1:10) {print(head(dfData[[j]]))}
for (j in 1:10) {print(head(tData[[j]]))}
for (j in 1:10) {print(head(xData[[j]]))}
for (j in 1:10) {print(head(zData[[j]]))}
}
\references{
P. Kiener, Explicit models for bilateral fat-tailed distributions and
applications in finance with the package FatTailsR, 8th R/Rmetrics Workshop
and Summer School, Paris, 27 June 2014. Download it from:
\url{http://www.inmodelia.com/exemples/2014-0627-Rmetrics-Kiener-en.pdf}

P. Kiener, Fat tail analysis and package FatTailsR - Season 2,
9th R/Rmetrics Workshop and Summer School, Zurich, 27 June 2015.
Download it from:
\url{http://www.inmodelia.com/exemples/2015-0627-Rmetrics-Kiener-en.pdf}
}
\seealso{
\code{\link{tData}}, \code{\link{xData}}, \code{\link{zData}}.
}
\keyword{datasets}

