% Generated by roxygen2 (4.0.1): do not edit by hand
\name{kashp}
\alias{ashp}
\alias{dkashp_dx}
\alias{kashp}
\title{Kashp Function}
\usage{
kashp(x, k = 1)

dkashp_dx(x, k = 1)

ashp(x, k = 1)
}
\arguments{
\item{x}{a numeric value, vector or matrix.}

\item{k}{a numeric value or vector, preferably strictly positive.}
}
\description{
\code{kashp}, which stands for kappa times arc-sine-hyperbola-power
is the nonlinear transformation of x at the heart
of power hyperbolas, power hyperbolic functions and symmetric Kiener
distributions.
\code{dkashp_dx} is its derivative with respect to \code{x}.
\code{ashp} is provided for convenience.
}
\details{
\code{ashp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ ashp(x, k) = asinh(x / 2 / k)  }
\code{kashp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ kashp(x, k) = k * asinh(x / 2 / k)  }
\code{dkashp_dx} function is defined for x in (-Inf, +Inf) by:
      \deqn{ dkashp_dx(x, k) = 1 / sqrt( x*x/k/k + 4 )
             = 1 / 2 / cosh( ashp(x, k) ) }

If k is a vector, then the use of the function \code{\link[base]{outer}}
is recommanded.

The undesired case k=0 returns 0 for kashp and dkashp_dx, 1 for exphp,
-Inf, NaN, +Inf for ashp.
}
\examples{
require(graphics)

### Example 1
x    <- (-2:3)*3 ; names(x) <- x
mat  <- matrix(x, ncol=2)
kashp(x, k=2)
kashp(mat, k=2)
k    <- c(-2, 0, 1, 2, 4, 10) ; names(k) <- k
outer(x, k, kashp)
outer(x, k, exphp)

### Example 2
xmin   <- -10
xd     <- 0.5
x      <- seq(xmin, -xmin, xd) ; names(x) <- x
k      <- c(0.6, 1, 1.5, 2, 3.2, 10) ; names(k) <- k
olty   <- c(2, 1, 2, 1, 2, 1, 1)
olwd   <- c(1, 1, 2, 2, 3, 4, 2)
ocol   <- c(2, 2, 4, 4, 3, 3, 1)
op     <- par(mfrow = c(2,2), mgp = c(1.5,0.8,0), mar = c(3,3,2,1))

Tkashp <- ts(cbind(outer(x, k, kashp), "x/2" = x/2), start = xmin, deltat = xd)
plot(Tkashp, plot.type = "single", ylim = c(-5, +5),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", xlab = "",
       ylab = "", main = "kashp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tkashp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

Tdkashp <- ts(cbind(outer(x, k, dkashp_dx)), start = xmin, deltat = xd)
plot(Tdkashp, plot.type = "single", ylim = c(0, 0.8),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", xlab = "",
       ylab = "", main="dkashp_dx(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tdkashp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

Tashp <- ts(cbind(outer(x, k, ashp), "x/2" = x/2), start = xmin, deltat = xd)
plot(Tashp, plot.type = "single", ylim = c(-5, +5),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", xlab = "",
       ylab = "", main = "ashp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tashp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )
### End example 2
}
\seealso{
The power hyperbolas and the power hyperbolic functions
\code{\link{exphp}}.
}

