% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{register_trend}
\alias{register_trend}
\title{Register a custom C++ trend kernel}
\usage{
register_trend(trend_parameters, file, transforms = NULL, base = "add")
}
\arguments{
\item{trend_parameters}{Character vector of kernel parameter names (in order).}

\item{file}{Path to the C++ file implementing the custom kernel. The file
should include EMC2/userfun.hpp and define a pointer creator (via
EMC2_MAKE_PTR) that is exported to R.}

\item{transforms}{Optional named character vector or list mapping each custom
kernel parameter name to a transform name (e.g., "identity", "exp", "pnorm").
Length must match \code{trend_parameters}. If unnamed but the correct length,
the order is assumed to match \code{trend_parameters}.}

\item{base}{Default base to use when creating trends with this custom kernel
if no \code{bases} argument is supplied to \code{make_trend}. One of
c("lin","exp_lin","centered","add","identity"). Default "add".}
}
\value{
An object to pass to \code{make_trend(custom_trend=...)}, carrying the
pointer, parameter names, default base, and optional transform mapping.
}
\description{
Compiles and registers a user-provided C++ function that maps per-trial
kernel parameters and inputs to a numeric vector. The C++ function must have
signature:
NumericVector f(NumericMatrix trend_pars, NumericMatrix input)
and provide an exported pointer creator using EMC2_MAKE_PTR.
}
