% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_map_stations.R
\name{EEAaq_map_stations}
\alias{EEAaq_map_stations}
\title{Create a static or dynamic (interactive leaflet) map representing the geographical locations of the
stations based on a user-defined input dataset of class \code{EEAaq_df} or \code{EEAaq_df_sfc}.}
\usage{
EEAaq_map_stations(
  data = NULL,
  NUTS_extborder = NULL,
  NUTS_intborder = NULL,
  color = TRUE,
  dynamic = FALSE
)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{NUTS_extborder}{character containing the NUTS level or LAU for which draw external boundaries.
Admissible values are 'NUTS0', 'NUTS1', 'NUTS2', 'NUTS3', 'LAU'.
Recall that the NUTS classification (Nomenclature of territorial units for statistics) is a hierarchical system for dividing up the economic territory of the EU and the UK.
The levels are defined as follows:
\itemize{
\item{\strong{NUTS 0}: the whole country}
\item{\strong{NUTS 1}: major socio-economic regions}
\item{\strong{NUTS 2}: basic regions for the application of regional policies}
\item{\strong{NUTS 3}: small regions for specific diagnoses}
\item{\strong{LAU}: municipality}
}}

\item{NUTS_intborder}{character containing the NUTS level or LAU for which draw internal boundaries.
Admissible values are 'NUTS0', 'NUTS1', 'NUTS2', 'NUTS3', 'LAU'.}

\item{color}{logical value (T or F). If \code{TRUE} (the default) the points are colored based on the pollutant they are
able to detect. If \code{FALSE} the points have the same color.}

\item{dynamic}{logical value (T or F). If \code{TRUE} the map is interactive and dynamic. If \code{FALSE} (the default) the map is static.}
}
\value{
A map representing the specified area and the points representing the location of the stations able to detect
the specified pollutants.
}
\description{
Create a static or dynamic (interactive leaflet) map representing the geographical locations of the
stations based on a user-defined input dataset of class \code{EEAaq_df} or \code{EEAaq_df_sfc}.
}
\examples{
\donttest{
`\%>\%` <- dplyr::`\%>\%`
### Retrieve all the stations measuring PM10 in Belgium
IDstations <- EEAaq_get_stations(byStation = FALSE, complete = FALSE)
IDstations <- IDstations \%>\%
  dplyr::filter(ISO \%in\% c("BE"),
                AirPollutant \%in\% "PM10") \%>\%
  dplyr::pull(AirQualityStationEoICode) \%>\%
  unique()

### Download the corresponding data froom December 1st to December 31st, 2021
data <- EEAaq_get_data(IDstations = IDstations, pollutants = "PM10",
                       from = "2021-12-01", to = "2021-12-31", verbose = TRUE)

### Static map of available stations across the whole country. External borders are given by the
###     union of the available regions (NUTS-2), while municipalities
## (LAUs) are used as inner borders.
EEAaq_map_stations(data = data,
                  NUTS_extborder = "NUTS2", NUTS_intborder = "LAU",
                  color = TRUE, dynamic = FALSE)
### Dynamic (interactive leaflet) map of available stations across the whole country.
## External borders are given by the
###     union of the available regions (NUTS-2), while provinces (NUTS-3) are used as inner borders.
EEAaq_map_stations(data = data,
                  NUTS_extborder = "NUTS2", NUTS_intborder = "NUTS3",
                  color = TRUE, dynamic = TRUE)
}

}
