% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{edc_left_join}
\alias{edc_left_join}
\alias{edc_right_join}
\alias{edc_full_join}
\title{Join within the EDCimport framework}
\usage{
edc_left_join(
  x,
  y,
  by = NULL,
  suffix = NULL,
  cols = everything(),
  remove_dups = FALSE
)
}
\arguments{
\item{x, y}{Data frames to join}

\item{by}{The key to join on, as character. Defaults to \code{get_subjid_cols()}}

\item{suffix}{The disambiguation suffix. Defaults to the actual name of the \code{y} dataset.}

\item{cols}{<\link[dplyr:dplyr_tidy_select]{tidy-select}> The columns to select in \code{y} before joining.}

\item{remove_dups}{Whether to remove columns in \code{y} that already exist in \code{x}.}
}
\value{
a dataframe
}
\description{
Perform a join with default \code{by} to the Subject ID and default suffix to the
name of the \code{y} dataset. See \verb{[dplyr::mutate-joins]} for the description of the
join logic.
}
\examples{
db = edc_example()
load_database(db)
data1$common = data2$common = "Common"
x = enrol \%>\% 
  edc_left_join(data2) \%>\% 
  edc_right_join(data1)
  
#crfname get a suffix, common 
names(x)
}
