% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{load_and_prepare_data_pro}
\alias{load_and_prepare_data_pro}
\title{Load and Prepare Data for Prognostic Models}
\usage{
load_and_prepare_data_pro(
  data_path,
  outcome_col_name,
  time_col_name,
  time_unit = c("day", "month", "year")
)
}
\arguments{
\item{data_path}{A character string, the file path to the input CSV data.
The first column is assumed to be a sample ID.}

\item{outcome_col_name}{A character string, the name of the column containing
event status (0 for censored, 1 for event).}

\item{time_col_name}{A character string, the name of the column containing
event or censoring time.}

\item{time_unit}{A character string, the unit of time in \code{time_col_name}.
Can be "day", "month", or "year". Times will be converted to days internally.}
}
\value{
A list containing:
\itemize{
\item \code{X}: A data frame of features (all columns except ID, outcome, and time).
\item \code{Y_surv}: A \code{survival::Surv} object created from time and outcome.
\item \code{sample_ids}: A vector of sample IDs (the first column of the input data).
\item \code{outcome_numeric}: A numeric vector of outcome status.
\item \code{time_numeric}: A numeric vector of time, converted to days.
}
}
\description{
Loads a CSV file containing patient data, extracts features,
outcome, and time columns, and prepares them into a format suitable for
survival analysis models. Handles basic data cleaning like NA removal
and column type conversion.
}
\examples{
temp_csv_path <- tempfile(fileext = ".csv")
dummy_data <- data.frame(
  ID = paste0("Patient", 1:50),
  FeatureA = rnorm(50),
  FeatureB = runif(50, 0, 100),
  CategoricalFeature = sample(c("A", "B", "C"), 50, replace = TRUE),
  Outcome_Status = sample(c(0, 1), 50, replace = TRUE),
  Followup_Time_Months = runif(50, 10, 60)
)
write.csv(dummy_data, temp_csv_path, row.names = FALSE)

# Load and prepare data
prepared_data <- load_and_prepare_data_pro(
  data_path = temp_csv_path,
  outcome_col_name = "Outcome_Status",
  time_col_name = "Followup_Time_Months",
  time_unit = "month"
)

# Check prepared data structure
str(prepared_data$X)
print(prepared_data$Y_surv[1:5])

# Clean up dummy file
unlink(temp_csv_path)
}
