% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Dyad Ratios Algorithm}
\arguments{
\item{varname}{String giving the name of the input series to be smoothed.
This should identify similar or comparable values in the series. Values in
the series that have the same \code{varname} will be assumed to come from
the same source.}

\item{date}{ISO numeric representation of the date the survey was in the
field (usually the start, end, or median date).}

\item{index}{Numeric value of the series. It might be a percent or proportion
responding in a single category (e.g., the approve response in presidential
approval) or some multi-response summary. For ease of interpretation,
polarity should be the same for all items.}

\item{ncases}{Number of cases (e.g., sample size) of the survey. This provides
differential weighting for the values. Setting this to \code{NULL} or
leaving it blank will weight each value equally.}

\item{unit}{Aggregation period—one of \sQuote{D} (daily), \sQuote{M}
(monthly), \sQuote{Q} (quarterly), \sQuote{A} (annual), or \sQuote{O}
(multi-year aggregation).}

\item{mult}{Number of years, only used if \code{unit} is \sQuote{O}.}

\item{begindt}{Beginning date of the analysis. Defaults to earliest date in
the dataset. Should be specified with \code{lubridate::ymd()}.}

\item{enddt}{Ending date for the analysis. Defaults to the latest date in the
data.}

\item{npass}{Not yet implemented.}

\item{smoothing}{Logical. Specifies whether exponential smoothing is applied
to the intermediate estimates during the iterative solution process.
Defaults to \code{TRUE}.}

\item{endmonth}{Ending month of the analysis.}
}
\value{
A list with components:
\itemize{
  \item \code{call}: The initial call to `extract()`. 
  \item \code{T}: Number of aggregation periods.
  \item \code{nvar}: Number of series used in the analysis.
  \item \code{unit}: The aggregation period.
  \item \code{dimensions}: Number of dimensions estimated (1 or 2).
  \item \code{period}: List of aggregation periods.
  \item \code{varname}: List in order of the variables used in the analysis.
  \item \code{N}: Number of non-missing observations for each series.
  \item \code{means}: Item descriptive information.
  \item \code{std.deviations}: Item descriptive information.
  \item \code{setup1}: Basic information about the options and iterative solution for the first dimension.
  \item \code{setup2}: Basic information about the options and iterative solution for the second dimension, if applicable.
  \item \code{loadings1}: Item–scale correlations from the first dimension of the final solution.
    Their square is the validity estimate used in weighting.
  \item \code{loadings2}: Item–scale correlations from the second dimension of the final solution, if applicable.
  \item \code{latent1}: Estimated time series for first dimension.
  \item \code{latent2}: Estimated time series for second dimension, if applicable.
  \item \code{hist}: Data frame with iteration history, including convergence statistics.
  \item \code{totalvar}: Total variance in the data that could be explained by the estimated dimensions.
  \item \code{var_exp}: Data frame with variance explained and proportion of variance explained for each dimension.
  \item \code{dropped}: Data frame listing any series that were dropped from the analysis due to insufficient data.
  \item \code{smoothing}: Logical indicating whether smoothing was applied during the iterative solution process.
}
}
\description{
Estimates the Dyad Ratios Algorithm for constructing latent time series from
survey-research marginals.
}
\examples{
data(jennings)
dr_out <- extract(varname = jennings$variable, 
                  date = jennings$date, 
                  index = jennings$value, 
                  ncases = jennings$n, 
                  begindt = min(jennings$date), 
                  enddt = max(jennings$date), 
                  npass=1)
summary(dr_out)

}
\references{
Stimson, J. A. (2018).
\sQuote{The Dyad Ratios Algorithm for Estimating Latent Public Opinion:
Estimation, Testing, and Comparison to Other Approaches},
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie
Sociologique}, 137–138(1), 201–218. \doi{10.1177/0759106318761614}
}
