% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_control_chart.R
\name{evaluate_control_chart_two_groups}
\alias{evaluate_control_chart_two_groups}
\title{Evaluate Control Charts}
\usage{
evaluate_control_chart_two_groups(
  chart_matrix_IC,
  time_matrix_IC,
  nobs_IC,
  starttime_IC,
  endtime_IC,
  chart_matrix_OC,
  time_matrix_OC,
  nobs_OC,
  starttime_OC,
  endtime_OC,
  design_interval,
  n_time_units,
  time_unit,
  no_signal_action = "omit"
)
}
\arguments{
\item{chart_matrix_IC, chart_matrix_OC}{charting statistics arranged as a numeric matrix. \cr
\code{chart_matrix_IC[i,j]} is the jth charting statistic of the ith IC subject. \cr
\code{chart_matrix_OC[i,j]} is the jth charting statistic of the ith OC subject.}

\item{time_matrix_IC, time_matrix_OC}{observation times arranged as a numeric matrix. \cr
\code{time_matrix_IC[i,j]} is the jth observation time of the ith IC subject. \cr
\code{time_matrix_OC[i,j]} is the jth observation time of the ith OC subject. \cr
\code{chart_matrix_IC[i,j]} is the charting statistic of the ith IC subject at \code{time_matrix[i,j]}. \cr
\code{chart_matrix_OC[i,j]} is the charting statistic of the ith OC subject at \code{time_matrix[i,j]}.}

\item{nobs_IC, nobs_OC}{number of observations arranged as an integer vector. \cr
\code{nobs_IC[i]} is the number of observations for the ith subject. \cr
\code{nobs_OC[i]} is the number of observations for the ith subject.}

\item{starttime_IC, starttime_OC}{a numeric vector that gives the start times. \cr
\code{starttime_IC[i]} is the time that the ith IC subject starts to be monitored. \cr
\code{starttime_OC[i]} is the time that the ith OC subject starts to be monitored.}

\item{endtime_IC, endtime_OC}{a numeric vector that gives the end times. \cr
\code{endtime_IC[i]} is the time that the ith IC subject is lost to be monitored. \cr
\code{endtime_OC[i]} is the time that the ith OC subject is lost to be monitored.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{no_signal_action}{a character value specifying how to set signal times when processes with no signals.\cr
If \code{no_signal_action=="omit"}, the signal time is set to be missing.\cr
If \code{no_signal_action=="maxtime"}, the signal time is set to be the time from start time to the end of the design interval.\cr
If \code{no_signal_action=="endtime"}, the signal time is set to be the time from start time to the end time.\cr}
}
\value{
an list that stores the evaluation measures. \cr
\item{$thres}{A numeric vector. Threshold values for control limits.}
\item{$FPR}{A numeric vector. False positive rates.}
\item{$TPR}{A numeric vector. True positive rates.}
\item{$ATS0}{A numeric vector. In-control ATS.}
\item{$ATS1}{A numeric vector. Out-of-control ATS.}
}
\description{
The function \code{evaluate_control_chart_two_groups} evaluates control charts when
the in-control (IC) and out-of-control (OC) charting statistics are supplied separately in two matrices 
\code{chart_matrix_IC} and \code{chart_matrix_OC}.
}
\details{
Evaluate Control Charts
}
\examples{
pattern<-estimate_pattern_long_1d(
  data_matrix=data_example_long_1d$data_matrix_IC,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  estimation_method="meanvar",
  smoothing_method="local linear",
  bw_mean=0.1,
  bw_var=0.1)

chart_IC_output<-monitor_long_1d(
  data_example_long_1d$data_matrix_IC,
  data_example_long_1d$time_matrix_IC,
  data_example_long_1d$nobs_IC,
  pattern=pattern,side="upward",chart="CUSUM",
  method="standard",parameter=0.2)

chart_OC_output<-monitor_long_1d(
  data_example_long_1d$data_matrix_OC,
  data_example_long_1d$time_matrix_OC,
  data_example_long_1d$nobs_OC,
  pattern=pattern,side="upward",chart="CUSUM",
  method="standard",parameter=0.2)

output_evaluate<-evaluate_control_chart_two_groups(
  chart_matrix_IC=chart_IC_output$chart[1:50,],
  time_matrix_IC=data_example_long_1d$time_matrix_IC[1:50,],
  nobs_IC=data_example_long_1d$nobs_IC[1:50],
  starttime_IC=rep(0,50),
  endtime_IC=rep(1,50),
  chart_matrix_OC=chart_OC_output$chart[1:50,],
  time_matrix_OC=data_example_long_1d$time_matrix_OC[1:50,],
  nobs_OC=data_example_long_1d$nobs_OC[1:50],
  starttime_OC=rep(0,50),
  endtime_OC=rep(1,50),
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  no_signal_action="maxtime")

}
\references{
Qiu, P. and Xiang, D. (2014). Univariate dynamic screening system: an approach for identifying individuals with irregular longitudinal behavior. Technometrics, 56:248-260. \cr
Qiu, P., Xia, Z., and You, L. (2020). Process monitoring ROC curve for evaluating dynamic screening methods. Technometrics, 62(2).
}
