% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_generation.R
\name{sample_size}
\alias{sample_size}
\title{[INTERNAL] Sample size for correlation computation}
\source{
Method to calculate samples in `pairwise.complete.obs` adopted and improved from
\code{\link[WGCNA]{corAndPvalue}}
}
\usage{
sample_size(measurement_data, handling_missing_data)
}
\arguments{
\item{measurement_data}{[data.frame] Data frame containing the respective raw data (e.g. mRNA expression data,
protein abundance, etc.) to the adjacency matrix. Analyzed components (e.g. genes) in rows, samples (e.g. patients)
in columns.}

\item{handling_missing_data}{["all.obs"|"pairwise.complete.obs"] Specifying the handling
of missing data during correlation matrix computation. (default: all.obs)}
}
\value{
For 'all.obs' returns an integer indicating the number of samples in the supplied
matrix (i.e. number of rows). For 'pairwise.complete.obs' returns a matrix in the same size
of the correlation matrix indicating the number of samples for each correlation calculation.
}
\description{
[INTERNAL] Depending on how missing data is handled in correlation matrix computation,
the number of samples used is returned. If `all.obs` is specified the number of rows (i.e. samples)
of the original data is returned. If `pairwise.complete.obs` is specified the crossproduct of a
matrix indicating the non-NA values is returned as matrix. This implementation was adopted
from \code{\link[WGCNA]{corAndPvalue}}.
}
\keyword{internal}
