% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnemar.R
\name{mcnemar_test_pv}
\alias{mcnemar_test_pv}
\alias{mcnemar.test.pv}
\title{McNemar's Test for Count Data}
\usage{
mcnemar_test_pv(
  x,
  alternative = "two.sided",
  exact = TRUE,
  correct = TRUE,
  simple_output = FALSE
)

mcnemar.test.pv(
  x,
  alternative = "two.sided",
  exact = TRUE,
  correct = TRUE,
  simple.output = FALSE
)
}
\arguments{
\item{x}{integer vector with four elements, a 2-by-2 matrix or an integer
matrix (or data frame) with four columns where each line
represents a 2-by-2 table to be tested.}

\item{alternative}{character vector that indicates the alternative hypotheses; each value must be one of \code{"two.sided"} (the default), \code{"less"} or \code{"greater"}.}

\item{exact}{logical value that indicates whether p-values are to be calculated by exact computation (\code{exact = TRUE}; the default) or by a continuous approximation.}

\item{correct}{logical value that indicates if a continuity correction is to be applied (\code{correct = TRUE}; the default) or not. Ignored, if \code{exact = TRUE}.}

\item{simple_output, simple.output}{logical value that indicates whether an R6 class object, including the tests' parameters and support sets, i.e. all observable p-values under each null hypothesis, is to be returned (see below).}
}
\value{
If \code{simple.output = TRUE}, a vector of computed p-values is returned.
Otherwise, the output is a \code{\link{DiscreteTestResults}} R6 class object, which
also includes the p-value supports and testing parameters. These have to be
accessed by public methods, e.g. \verb{$get_pvalues()}.
}
\description{
Performs McNemar's chi-square test or an exact variant to assess the symmetry
of rows and columns in a 2-by-2 contingency table. In contrast to
\code{\link[stats:mcnemar.test]{stats::mcnemar.test()}}, it is vectorised, only calculates p-values and
offers their exact computation. Furthermore, it is capable of returning the
discrete p-value supports, i.e. all observable p-values under a null
hypothesis. Multiple tables can be analysed simultaneously. In two-sided
tests, several procedures of obtaining the respective p-values are
implemented. It is a special case of the \link[=binom_test_pv]{binomial test}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
\strong{Note}: Please use \code{mcnemar_test_pv()}! The older \code{mcnemar.test.pv()} is
deprecated in order to migrate to snake case. It will be removed in a future
version.
}
\details{
The parameters \code{x} and \code{alternative} are vectorised. They are replicated
automatically, such that the number of \code{x}'s rows is the same as the length
of \code{alternative}. This allows multiple null hypotheses to be tested
simultaneously. Since `x is (if necessary) coerced to a matrix with four
columns, it is replicated row-wise.

It can be shown that McNemar's test is a special case of the binomial test.
Therefore, its computations are handled by \code{\link[=binom_test_pv]{binom_test_pv()}}. In
contrast to that function, \code{mcnemar_test_pv()} does not allow specifying
exact two-sided p-value calculation procedures. The reason is that McNemar's
exact test always tests for a probability of 0.5, in which case all these
exact two-sided p-value computation methods yield exactly the same results.
}
\examples{
# Constructing
S1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
S2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
F1 <- N1 - S1
F2 <- N2 - S2
df <- data.frame(S1, F1, S2, F2)

# Computation of exact p-values and their supports
results_ex  <- mcnemar_test_pv(df)
raw_pvalues <- results_ex$get_pvalues()
pCDFlist    <- results_ex$get_pvalue_supports()

# Computation of chisquare p-values and their supports
results_cs  <- mcnemar_test_pv(df, exact = FALSE)
raw_pvalues <- results_cs$get_pvalues()
pCDFlist    <- results_cs$get_pvalue_supports()

}
\references{
Agresti, A. (2002). \emph{Categorical data analysis} (2nd ed.). New York: John
Wiley & Sons. pp. 411–413. \doi{10.1002/0471249688}
}
\seealso{
\code{\link[stats:mcnemar.test]{stats::mcnemar.test()}}, \code{\link[=binom_test_pv]{binom_test_pv()}}
}
