#' SEIRSd model
#' 
#' @description A SEIRS model with 4 compartments
#' 
#' @details The model includes susceptible, exposed/asymptomatic, infected/symptomatic, and recovered compartments. The processes that are modeled are infection, progression to infectiousness, recovery and waning immunity. Demographics through natural births and deaths are also included.
#' 
#' This code was generated by the modelbuilder R package.  
#' The model is implemented as a set of stochastic equations using the adaptivetau package. 
 
#' The following R packages need to be loaded for the function to work: adpativetau 
#' 
#' Starting conditions for model variables 
#' @param S : starting value for Susceptible : numeric
#' @param E : starting value for Exposed : numeric
#' @param I : starting value for Infected and Symptomatic : numeric
#' @param R : starting value for Recovered : numeric
#' Values for model parameters : numeric 
#' @param bE : infection by exposed : numeric
#' @param bI : infection by symptomatic : numeric
#' @param gE : progression rate : numeric
#' @param gI : recovery rate : numeric
#' @param w : waning immunity : numeric
#' @param n : births : numeric
#' @param m : deaths : numeric
#' @param rngseed : set random number seed for reproducibility : numeric
#' Values for model times : numeric 
#' @param tstart : Start time of simulation : numeric
#' @param tfinal : Final time of simulation : numeric
#' @param dt : Time step : numeric
#' @return The function returns the output as a list. 
#' The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
#' The \code{ts} dataframe has one column per compartment/variable. The first column is time.   
#' @examples  
#' # To run the simulation with default parameters:  
#' result <- simulate_SEIRSd_model_stochastic() 
#' # To choose values other than the standard one, specify them like this:  
#' result <- simulate_SEIRSd_model_stochastic(S = 2000,E = 2,I = 2,R = 0) 
#' # You can display or further process the result, like this:  
#' plot(result$ts[,'time'],result$ts[,'S'],xlab='Time',ylab='Numbers',type='l') 
#' print(paste('Max number of S: ',max(result$ts[,'S']))) 
#' @section Warning: This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
#' @section Model Author: Andreas Handel
#' @section Model creation date: 2020-09-28
#' @section Code Author: generated by the \code{modelbuilder} R package 
#' @section Code creation date: 2020-09-28
#' @export 
 
simulate_SEIRSd_model_stochastic <- function(S = 1000, E = 1, I = 1, R = 0, bE = 0, bI = 0.001, gE = 1, gI = 1, w = 1, n = 0, m = 0, tstart = 0, tfinal = 100, dt = 0.1, rngseed = 123) 
{ 
  #Block of ODE equations for adaptivetau 
  SEIRSd_model_fct <- function(y, parms, t) 
  {
    with(as.list(c(y,parms)),   
     { 
       #specify each rate/transition/reaction that can happen in the system 
     rates = c(bE*S*E, bI*S*I, gE*E, gI*I, w*R, m*E, m*I, m*R, m*S, n)
     return(rates) 
      }
	 	)   
  } # end function specifying rates used by adaptive tau 

   #specify for each reaction/rate/transition how the different variables change 
  #needs to be in exactly the same order as the rates listed in the rate function 
  transitions = list(c(S = -1,E = +1), 
 	 	 				c(S = -1,E = +1), 
 	 	 				c(I = +1,E = -1), 
 	 	 				c(R = +1,I = -1), 
 	 	 				c(R = -1,S = +1), 
 	 	 				c(E = -1), 
 	 	 				c(I = -1), 
 	 	 				c(R = -1), 
 	 	 				c(S = -1), 
 	 	 				c(S = +1)) 
 
  ############################## 
  #Main function code block 
  ############################## 
  set.seed(rngseed) #set random number seed for reproducibility 
  #Creating named vectors 
  varvec = c(S = S, E = E, I = I, R = R) 
  parvec = c(bE = bE, bI = bI, gE = gE, gI = gI, w = w, n = n, m = m) 
  #Running the model 
  simout = adaptivetau::ssa.adaptivetau(init.values = varvec, transitions = transitions,
                  	 	 	 rateFunc = SEIRSd_model_fct, params = parvec, tf = tfinal) 
  #Setting up empty list and returning result as data frame called ts 
  result <- list() 
  result$ts <- as.data.frame(simout) 
  return(result) 
 }