# Documentation for working on the DSAIDE package 

## Package structure 

### Main functions
* The main R functions, i.e. the simulattors and various helper functions are in the /R folder. All simulators, which are meant to be called by advanced users start with simulate_. Other functions are only needed for the package/UI to work and are not meant to be directly accessed by users.


### App materials
* The /inst folder contains several subfolders: 
  * The /mainmenu subfolder contains the main app.R Shiny app
  * The /appinformation subfolder contains files with documentation and settings for each simulator/app. Each App has an NNN_settings.R file and Rmd+HTML files containing the documentation. Those files contain the documentation displayed at the bottom of each app, and app-specific settings that are needed for proper display and running through the UI. Names of files and buttons in the main app.R need to agree.
  * The /media sub-folder contains figures and a bib file used as part of the documentation (i.e. the Rmd files). It also includes a css file for styling. 
  * The /docsfordevelopers contains this file. 
  * /simulatorfunctions subfolder contains the R code for all simulator functions for easy access and editing by users.
  * The /doc folder contains the vignettes, this folder should not be edited, see below.
  * The /extdata bfolder contains data used as part of the R package.

### Other folders
* folder /auxiliary contains related resources that are not needed for package use or build
* folder /docs contains the package website created by the pkgdown package. Rebuild with pkgdown::build_site()
* folder /man contains the documentation for all public functions, automatically generated by roxygen
* folder /tests contains unit tests, done with the testthat package
* folder /vignettes contains the vignette - this is copied to /inst/doc during package building. edits should be done to the file in the /vignettes folder, not the /inst/doc folder.

## Making new Apps

### Building the App
The easiest way is to copy one of the apps in the allapps folder and use it as template. The following steps are required:

* Write the main simulator function.
* Write the _settings.R file. 
* Write the documentation as Rmd and turn it into an HTML.

### Contributing your App
The best approach is to contact me by email (ahandel@uga.edu) or through the Github site, tell me that you have a new app and share it with me. I'll test it, we'll probably have a few discussions, and if I think it's suitable, I'll add it to the package. Of course, you will be credited for the app you developed. Also, if you plan to write and contribute new apps, maybe best if you contact me beforehand, I can then help and provide guidance as needed.


## Information for package development

### To work on package through RStudio: 
* Load DSAIDE.Rproj in RStudio. Edit files as needed.
* Optionally, use RStudio tie-in with github to sync project to github (the 'git' tab).

### Dependency packages for development
* roxygen
* devtools
* testthat
* codecov
* rmarkdown for vignette and shiny documentation
* pkgdown for package doc site
* packages needed: see DESCRIPTION file
* Rtools needs to be installed (on Windows)
* All libraries/packages needed by this one should be loaded via the DESCRIPTION file and not in separate R files

### To update R documentation and vignette
* Edit documentation inside R functions. 
* Build documentation with More/Document or devtools::document()
* Edit vignette inside the /vignettes folder.
* To build new vignette, run devtools::build_vignettes()
* To update the pkgdown website, run pkgdown::build_site()
* To spell-check all Rmd documentation files, use these commands (adjust paths as needed):
files = list.files(path = "C:/data/git/DSAIDE/inst/appinformation/", recursive=TRUE, pattern = "\\.Rmd$", full.names = TRUE)
spelling::spell_check_files(files)
* To re-build all html documentation files from the rmd files at once, use these above command and:
for (n in 1: length(files)) {rmarkdown::render(files[n]); Sys.sleep(5)}



### To build the package
* "by hand" edit the DESCRIPTION file to make sure it's up to date
* in RStudio, use the functions in the 'build' tab to test and build the package.
* Run clean and rebuild, then build and reload using menu, or devtools::load_all()
* Run the check, fix any errors 

### To-do at release time 
* Re-build documentation, re-build package
* Re-build vignettes with devtools::build_vignettes()
* Run check and make sure no problems occur
* Re-create package site with pkgdown::build_site()
* Sync everything to github
* Check vignette and function references on website, fix errors
* Run devtools::check_rhub() and devtools::check_win_devel()
* Do a test run of devtools::release()
