#' A phylogenetic tree of plant species.
#'
#' This is a mock dataset for demonstrating the \pkg{DAISIEprep} package.
#'
#' @format ## `plant_phylo`
#' A `phylo` object (from the \pkg{ape} package) with 10 tips and 9 internal
#' nodes. Each tip label is formatted `"Plant_*"` with the letters `a`, `b`,
#' etc. used as species names.
"plant_phylo"

#' Phylogenetic trees of the Galapagos bird lineages and sister species on the
#' mainland.
#'
#' Each dataset is a phylogenetic tree used to extract the Galapagos avifaunal
#' lineages.
#'
#' @format A `phylo` object (from the \pkg{ape} package)
#' @name GalapagosTrees
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"coccyzus_tree"

#' @rdname GalapagosTrees
"columbiformes_tree"

#' @rdname GalapagosTrees
"finches_tree"

#' @rdname GalapagosTrees
"mimus_tree"

#' @rdname GalapagosTrees
"myiarchus_tree"

#' @rdname GalapagosTrees
"progne_tree"

#' @rdname GalapagosTrees
"pyrocephalus_tree"

#' @rdname GalapagosTrees
"setophaga_tree"

#' A phylogenetic tree of coccyzus species with endemicity status as tip states.
#'
#' @format ## `coccyzus_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(coccyzus_phylod)` tips and
#' `r phylobase::nNodes(coccyzus_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"coccyzus_phylod"

#' A phylogenetic tree of columbiformes species with endemicity status as
#' tip states.
#'
#' @format ## `columbiformes_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(columbiformes_phylod)` tips and
#' `r phylobase::nNodes(columbiformes_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"columbiformes_phylod"

#' A phylogenetic tree of finches species with endemicity status as tip states.
#'
#' @format ## `finches_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(finches_phylod)` tips and
#' `r phylobase::nNodes(finches_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"finches_phylod"

#' A phylogenetic tree of mimus species with endemicity status as tip states.
#'
#' @format ## `mimus_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(mimus_phylod)` tips and
#' `r phylobase::nNodes(mimus_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"mimus_phylod"

#' A phylogenetic tree of myiarchus species with endemicity status as tip states.
#'
#' @format ## `myiarchus_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(myiarchus_phylod)` tips and
#' `r phylobase::nNodes(myiarchus_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"myiarchus_phylod"

#' A phylogenetic tree of progne species with endemicity status as tip states.
#'
#' @format ## `progne_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(progne_phylod)` tips and
#' `r phylobase::nNodes(progne_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"progne_phylod"

#' A phylogenetic tree of pyrocephalus species with endemicity status as
#' tip states.
#'
#' @format ## `pyrocephalus_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(pyrocephalus_phylod)` tips and
#' `r phylobase::nNodes(pyrocephalus_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"pyrocephalus_phylod"

#' A phylogenetic tree of setophaga species with endemicity status as
#' tip states.
#'
#' @format ## `setophaga_phylod`
#' A `phylo4d` object (from the \pkg{phylobase} package) with
#' `r phylobase::nTips(setophaga_phylod)` tips and
#' `r phylobase::nNodes(setophaga_phylod)` internal
#' nodes.
#' @source Valente, L.M., A.B. Phillimore and R.S. Etienne (2015). Equilibrium
#' and non-equilibrium dynamics simultaneously operate in the Galapagos
#' islands. Ecology Letters 18: 844-852.
"setophaga_phylod"
