% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Bucaramanga_wifi_tbl_df}
\alias{Bucaramanga_wifi_tbl_df}
\title{WiFi Connectivity Zones in Bucaramanga (Spanish speaking)}
\format{
A tibble with 82 observations and 9 variables:
\describe{
  \item{NOMBRE ZONA WIFI}{Name of the WiFi zone (character)}
  \item{DIRECCION}{Address of the WiFi zone (character)}
  \item{BARRIO}{Neighborhood of the WiFi zone (character)}
  \item{COMUNA}{Commune of the WiFi zone (character)}
  \item{ZONA (URBANA/RURAL)}{Urban or rural classification (character)}
  \item{DEPARTAMENTO}{Department where the zone is located (character)}
  \item{MUNICIPIO}{Municipality where the zone is located (character)}
  \item{LATITUD}{Latitude coordinate of the WiFi zone (character)}
  \item{LONGITUD}{Longitude coordinate of the WiFi zone (character)}
}
}
\source{
Data obtained from GOV.CO Datos Abiertos: \url{https://www.datos.gov.co/Ciencia-Tecnolog-a-e-Innovaci-n/SERVICIO-DE-CONECTIVIDAD-ZONAS-WIFI/9n9m-2dqq/about_data}
}
\usage{
data(Bucaramanga_wifi_tbl_df)
}
\description{
This dataset, Bucaramanga_wifi_tbl_df, is a tibble containing information about
community WiFi connection zones in the municipality of Bucaramanga. It includes
details such as the zone name, address, neighborhood, commune, urban or rural
classification, department, municipality, and geographic coordinates.
This dataset was taken from GOV.CO Datos Abiertos, last update on September 20, 2025.
}
\details{
The dataset name has been kept as 'Bucaramanga_wifi_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ColombiAPI package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not
been modified in any way.
}
