% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SGV.R
\name{sgvSetup}
\alias{sgvSetup}
\title{One-time setup wrapper function for the SGV approximation}
\usage{
sgvSetup(
  coords,
  coords_pred = NULL,
  k = 15,
  seed = NULL,
  pred.seed = NULL,
  order_coords = TRUE
)
}
\arguments{
\item{coords}{Matrix of observed locations.}

\item{coords_pred}{Optional matrix of prediction locations.}

\item{k}{Number of neighbors.}

\item{seed}{Setting the seed for reproducibility of the observed location
ordering}

\item{pred.seed}{Setting the seed for reproducibility of the prediction 
ordering.}

\item{order_coords}{Logical; should the coordinates be ordered.}
}
\value{
A list with the following components:
\item{ord}{A vector of ordering position for the observed locations.}
\item{ord_pred}{A vector of ordering position for the prediction 
locations (if \code{coords_pred} is provided).}
\item{ord_all}{A concatenated vector of \code{ord} and \code{ord_pred}.}
\item{coords_ord}{A matrix of ordered locations (observed and prediction),
included for convenience.}
\item{nID_ord}{A matrix of (ordered) neighbor indices.}
\item{condition_on_y_ord}{A matrix indicating whether the conditioning
set for each (ordered) location is on the latent process (y, \code{1}) or
the observed values (z, \code{0}).}
}
\description{
\code{sgvSetup} is a wrapper function that sets up the SGV approximation. 
Three objects are required: (1) ordering the locations, (2) identify nearest
neighbors, and (3) determine the conditioning set. This function only needs
to be run once per SGV analysis.
}
