% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BernoulliCode.R
\name{genbernoullidata}
\alias{genbernoullidata}
\title{Generating function for Bernoulli Data.}
\usage{
genbernoullidata(sample_size, prob1, odds_ratio)
}
\arguments{
\item{sample_size}{Number of subjects per arm.}

\item{prob1}{prob parameter used in call to \code{rbinom()}.
Used only in control arm.}

\item{odds_ratio}{Desired Odds Ratio between experimental and control groups.}
}
\value{
\code{genlogisticdata()} returns a data frame with columns: 'id', 'treatment',
  and 'y'.
}
\description{
\code{genlogisticdata()} function used mainly internally by
\code{logistictrialsimulator()} function to generate data for a two-arm
clinical trial, experimental and control groups.  Can be used to generate
random trial data.
}
\examples{
samplehistdata <- genbernoullidata(sample_size=60, prob1=0.6, odds_ratio=0.6)
samplehistdata
}
